/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.conn.impl;

import com.easy.query.core.basic.jdbc.conn.EasyConnection;
import com.easy.query.core.basic.jdbc.conn.EasyDataSourceConnection;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.EasyQueryDataSource;
import com.easy.query.core.util.EasyCollectionUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultEasyDataSourceConnection
implements EasyDataSourceConnection {
    private static final Log log = LogFactory.getLog(DefaultEasyDataSourceConnection.class);
    private final Map<String, EasyConnection> connections = new HashMap<String, EasyConnection>();
    private final EasyQueryDataSource easyQueryDataSource;

    public DefaultEasyDataSourceConnection(EasyQueryDataSource easyQueryDataSource) {
        this.easyQueryDataSource = easyQueryDataSource;
    }

    @Override
    public Collection<EasyConnection> getConnections() {
        return this.connections.values();
    }

    @Override
    public EasyConnection getEasyConnectionOrNull(String dataSource) {
        return this.connections.get(dataSource);
    }

    @Override
    public void putIfAbsent(String dataSource, EasyConnection easyConnection) {
        EasyConnection result = this.connections.put(dataSource, easyConnection);
        if (result != null) {
            throw new EasyQuerySQLCommandException("repeat add easy connection:" + dataSource);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        for (EasyConnection connection : this.getConnections()) {
            connection.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void commit() {
        int connectionSize = this.getConnections().size();
        ArrayList<SQLException> exceptions = connectionSize > 1 ? new ArrayList<SQLException>(connectionSize) : null;
        int i = 0;
        for (EasyConnection connection : this.getConnections()) {
            try {
                connection.commit();
            }
            catch (SQLException ex) {
                log.error("commit error.", ex);
                if (i == 0) {
                    throw new EasyQuerySQLCommandException(ex);
                }
                assert (exceptions != null);
                exceptions.add(ex);
            }
            ++i;
        }
        this.throwAggregateSQLException(exceptions);
    }

    private void throwAggregateSQLException(Collection<SQLException> exceptions) {
        if (EasyCollectionUtil.isEmpty(exceptions)) {
            return;
        }
        SQLException ex = new SQLException("");
        exceptions.forEach(ex::setNextException);
        throw new EasyQuerySQLCommandException(ex);
    }

    @Override
    public void rollback() {
        int connectionSize = this.getConnections().size();
        ArrayList<SQLException> exceptions = connectionSize > 0 ? new ArrayList<SQLException>(connectionSize) : null;
        for (EasyConnection connection : this.getConnections()) {
            try {
                connection.rollback();
            }
            catch (SQLException ex) {
                log.error("rollback error.", ex);
                assert (exceptions != null);
                exceptions.add(ex);
            }
        }
        this.throwAggregateSQLException(exceptions);
    }

    @Override
    public void close() {
        for (EasyConnection connection : this.getConnections()) {
            try {
                connection.close();
            }
            catch (Exception ex) {
                log.error("close error ignored.", ex);
            }
        }
    }
}

