/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.common;

import com.easy.query.core.basic.jdbc.executor.internal.common.SQLRewriteUnit;
import com.easy.query.core.basic.jdbc.parameter.DefaultToSQLContext;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.sql.TableContext;
import com.easy.query.core.expression.sql.expression.EntitySQLExpression;
import java.util.List;

public class SQLRouteUnit {
    private final String sql;
    private final List<SQLParameter> parameters;
    private final List<Object> entities;
    private final boolean fillAutoIncrement;

    public SQLRouteUnit(String sql, List<SQLParameter> parameters) {
        this(sql, parameters, null, false);
    }

    public SQLRouteUnit(String sql, List<SQLParameter> parameters, List<Object> entities, boolean fillAutoIncrement) {
        this.sql = sql;
        this.parameters = parameters;
        this.entities = entities;
        this.fillAutoIncrement = fillAutoIncrement;
    }

    public SQLRouteUnit(EntitySQLExpression easyEntitySQLExpression, List<Object> entities, boolean fillAutoIncrement, SQLRewriteUnit sqlRewriteUnit) {
        TableContext tableContext = easyEntitySQLExpression.getExpressionMetadata().getTableContext();
        ToSQLContext toSQLContext = DefaultToSQLContext.defaultToSQLContext(tableContext, sqlRewriteUnit);
        String sql = easyEntitySQLExpression.toSQL(toSQLContext);
        this.entities = entities;
        this.fillAutoIncrement = fillAutoIncrement;
        this.sql = sql;
        this.parameters = toSQLContext.getParameters();
    }

    public String getSQL() {
        return this.sql;
    }

    public List<SQLParameter> getParameters() {
        return this.parameters;
    }

    public List<Object> getEntities() {
        return this.entities;
    }

    public boolean isFillAutoIncrement() {
        return this.fillAutoIncrement;
    }
}

