/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.annotation.NotNull;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.BasicStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.DefaultBeanStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.DraftResult;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.DraftStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.FastBeanStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.MapStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.MapTypeStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.StreamIterable;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.enums.EntityMetadataTypeEnum;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.sql.SQLException;
import java.util.Iterator;

public class DefaultStreamIterable<T>
implements StreamIterable<T> {
    private final ExecutorContext context;
    private final ResultMetadata<T> resultMetadata;
    private final StreamResultSet streamResultSet;

    public DefaultStreamIterable(ExecutorContext context, ResultMetadata<T> resultMetadata, StreamResultSet streamResultSet) {
        this.context = context;
        this.resultMetadata = resultMetadata;
        this.streamResultSet = streamResultSet;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        try {
            return this.iterator0();
        }
        catch (SQLException e) {
            throw new EasyQuerySQLCommandException(e);
        }
    }

    private Iterator<T> iterator0() throws SQLException {
        EntityMetadataTypeEnum entityMetadataType = this.resultMetadata.getEntityMetadataType();
        switch (entityMetadataType) {
            case MAP: {
                if (EasyArrayUtil.isNotEmpty(this.context.getExpressionContext().getResultPropTypes())) {
                    return (Iterator)EasyObjectUtil.typeCastNullable(new MapTypeStreamIterator(this.context, this.streamResultSet, (ResultMetadata)EasyObjectUtil.typeCastNullable(this.resultMetadata)));
                }
                return new MapStreamIterator<T>(this.context, this.streamResultSet, this.resultMetadata);
            }
            case BASIC_TYPE: {
                return new BasicStreamIterator<T>(this.context, this.streamResultSet, this.resultMetadata);
            }
        }
        if (this.resultMetadata.getDataReader() != null) {
            return new FastBeanStreamIterator<T>(this.context, this.streamResultSet, this.resultMetadata);
        }
        if (DraftResult.class.isAssignableFrom(this.resultMetadata.getResultClass())) {
            return (Iterator)EasyObjectUtil.typeCastNullable(new DraftStreamIterator(this.context, this.streamResultSet, (ResultMetadata)EasyObjectUtil.typeCastNullable(this.resultMetadata)));
        }
        return new DefaultBeanStreamIterator<T>(this.context, this.streamResultSet, this.resultMetadata);
    }
}

