/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.basic.jdbc.executor.internal.enumerable.JdbcResult;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.JdbcStreamResult;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.StreamIterable;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyJdbcExecutorUtil;
import java.sql.SQLException;
import java.util.List;

public class ResultSizeLimitJdbcResult<TR>
implements JdbcResult<TR> {
    private static final Log log = LogFactory.getLog(ResultSizeLimitJdbcResult.class);
    private final long resultSizeLimit;
    private final JdbcStreamResult<TR> jdbcStreamResult;

    public ResultSizeLimitJdbcResult(long resultSizeLimit, JdbcStreamResult<TR> jdbcStreamResult) {
        if (resultSizeLimit <= 0L) {
            throw new IllegalArgumentException("resultSizeLimit <= 0.");
        }
        this.resultSizeLimit = resultSizeLimit;
        this.jdbcStreamResult = jdbcStreamResult;
    }

    @Override
    public JdbcStreamResult<TR> getJdbcStreamResult() {
        return this.jdbcStreamResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TR> toList() {
        try (JdbcStreamResult<TR> jdbcStreamResultSet = this.jdbcStreamResult;){
            StreamIterable<TR> streamResult = jdbcStreamResultSet.getStreamIterable();
            List<TR> list = EasyCollectionUtil.newArrayList(streamResult, this.resultSizeLimit);
            if (EasyJdbcExecutorUtil.isPrintSQL(this.jdbcStreamResult.getExecutorContext())) {
                log.info("<== Total: " + list.size());
            }
            List<TR> list2 = list;
            return list2;
        }
        catch (SQLException e) {
            throw new EasyQuerySQLCommandException(e);
        }
    }
}

