/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.OrderStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.segment.PropertyOrder;
import com.easy.query.core.sharding.comparer.ShardingComparer;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EasyOrderStreamMergeResultSet
implements OrderStreamMergeResultSet {
    private static final List<Comparable<?>> EMPTY_COMPARABLE_VALUES = Collections.emptyList();
    private final StreamMergeContext streamMergeContext;
    private final StreamResultSet streamResultSet;
    private List<Comparable<?>> orderValues;
    private boolean closed = false;

    public EasyOrderStreamMergeResultSet(StreamMergeContext streamMergeContext, StreamResultSet streamResultSet) throws SQLException {
        this.streamMergeContext = streamMergeContext;
        this.streamResultSet = streamResultSet;
        this.setOrderValues();
    }

    private void setOrderValues() throws SQLException {
        this.orderValues = this.hasElement() ? this.getCurrentOrderValues() : EMPTY_COMPARABLE_VALUES;
    }

    private List<Comparable<?>> getCurrentOrderValues() throws SQLException {
        if (EasyCollectionUtil.isEmpty(this.streamMergeContext.getOrders())) {
            return EMPTY_COMPARABLE_VALUES;
        }
        ArrayList orders = new ArrayList(this.streamMergeContext.getOrders().size());
        for (PropertyOrder order : this.streamMergeContext.getOrders()) {
            Object value = this.streamResultSet.getObject(order.columnIndex() + 1);
            if (value == null || value instanceof Comparable) {
                orders.add((Comparable)value);
                continue;
            }
            throw new UnsupportedOperationException(" order by value:" + order.propertyName() + "must implements Comparable<?>");
        }
        return orders;
    }

    @Override
    public boolean hasElement() {
        return this.streamResultSet.hasElement();
    }

    @Override
    public boolean skipFirst() {
        return this.streamResultSet.skipFirst();
    }

    @Override
    public boolean next() throws SQLException {
        boolean next = this.streamResultSet.next();
        this.setOrderValues();
        return next;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.streamResultSet.getObject(columnIndex);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.streamResultSet.getObject(columnIndex, type);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.streamResultSet.wasNull();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.streamResultSet.getMetaData();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.streamResultSet.getSQLXML(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.streamResultSet.getTimestamp(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.streamResultSet.getTime(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.streamResultSet.getString(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.streamResultSet.getDate(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.streamResultSet.getShort(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.streamResultSet.getLong(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.streamResultSet.getInt(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.streamResultSet.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.streamResultSet.getDouble(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.streamResultSet.getClob(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.streamResultSet.getByte(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.streamResultSet.getBytes(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.streamResultSet.getBoolean(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.streamResultSet.getBlob(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.streamResultSet.getBigDecimal(columnIndex);
    }

    @Override
    public List<Comparable<?>> compareValues() {
        if (this.orderValues == null) {
            return EMPTY_COMPARABLE_VALUES;
        }
        return this.orderValues;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.streamResultSet.close();
    }

    @Override
    public int compareTo(OrderStreamMergeResultSet o) {
        if (EasyCollectionUtil.isEmpty(this.streamMergeContext.getOrders())) {
            return 0;
        }
        ShardingComparer shardingComparer = this.streamMergeContext.getRuntimeContext().getShardingComparer();
        int i = 0;
        boolean reverseMerge = this.streamMergeContext.isReverseMerge();
        for (PropertyOrder order : this.streamMergeContext.getOrders()) {
            int compared = shardingComparer.compare(this.orderValues.get(i), o.compareValues().get(i), order.asc() == !reverseMerge);
            if (compared != 0) {
                return compared;
            }
            ++i;
        }
        return 0;
    }
}

