/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.aggregation.AggregationUnitFactory;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.AggregateValue;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.GroupByRowComparator;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.GroupValue;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.AbstractInMemoryStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.DefaultMemoryResultSetRow;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.MemoryResultSetRow;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.expression.func.AggregationType;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.MaybeAggregateColumnSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.context.ColumnIndexFuncColumnSegment;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class EasyInMemoryGroupByOrderStreamMergeResultSet
extends AbstractInMemoryStreamMergeResultSet {
    private static final Log log = LogFactory.getLog(EasyInMemoryGroupByOrderStreamMergeResultSet.class);

    public EasyInMemoryGroupByOrderStreamMergeResultSet(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        super(streamMergeContext, streamResultSets);
    }

    @Override
    protected List<MemoryResultSetRow> init(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        LinkedHashMap<GroupValue, MemoryResultSetRow> dataMap = new LinkedHashMap<GroupValue, MemoryResultSetRow>(1024);
        LinkedHashMap<GroupValue, List<AggregateValue>> aggregationMap = new LinkedHashMap<GroupValue, List<AggregateValue>>(1024);
        for (StreamResultSet resultSet : streamResultSets) {
            try {
                StreamResultSet streamResultSet = resultSet;
                Throwable throwable = null;
                try {
                    while (streamResultSet.next()) {
                        GroupValue groupValue = new GroupValue(streamMergeContext, streamResultSet);
                        this.initForFirstGroupByValue(streamMergeContext, streamResultSet, groupValue, dataMap, aggregationMap);
                        this.aggregate(streamResultSet, groupValue, aggregationMap);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (streamResultSet == null) continue;
                    if (throwable != null) {
                        try {
                            streamResultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    streamResultSet.close();
                }
            }
            catch (Exception e) {
                log.error("init memory merge result set error.", e);
                throw new SQLException(e);
            }
        }
        this.setAggregationValueToMemoryRow(streamMergeContext, dataMap, aggregationMap);
        List<Boolean> valueCaseSensitive = EasyCollectionUtil.isEmpty(streamResultSets) ? Collections.emptyList() : this.getValueCaseSensitive();
        return this.getMemoryResultSetRows(streamMergeContext, dataMap, valueCaseSensitive);
    }

    private List<MemoryResultSetRow> getMemoryResultSetRows(StreamMergeContext streamMergeContext, Map<GroupValue, MemoryResultSetRow> dataMap, List<Boolean> valueCaseSensitive) {
        ArrayList<MemoryResultSetRow> resultSetRows = new ArrayList<MemoryResultSetRow>(dataMap.values());
        resultSetRows.sort(new GroupByRowComparator(streamMergeContext, valueCaseSensitive));
        return resultSetRows;
    }

    public List<Boolean> getValueCaseSensitive() throws SQLException {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            result.add(this.metaData.isCaseSensitive(i + 1));
        }
        return result;
    }

    private void initForFirstGroupByValue(StreamMergeContext streamMergeContext, StreamResultSet streamResultSet, GroupValue groupValue, Map<GroupValue, MemoryResultSetRow> dataMap, Map<GroupValue, List<AggregateValue>> aggregationMap) throws SQLException {
        if (!dataMap.containsKey(groupValue)) {
            dataMap.put(groupValue, new DefaultMemoryResultSetRow(streamResultSet, this.columnCount));
        }
        if (!aggregationMap.containsKey(groupValue)) {
            List<AggregateValue> aggregationUnitValues = this.createAggregationUnitValues();
            aggregationMap.put(groupValue, aggregationUnitValues);
        }
    }

    private void aggregate(StreamResultSet streamResultSet, GroupValue groupValue, Map<GroupValue, List<AggregateValue>> aggregationMap) throws SQLException {
        List<AggregateValue> aggregateValues = aggregationMap.get(groupValue);
        for (AggregateValue aggregationValue : aggregateValues) {
            ArrayList comparables = new ArrayList(2);
            if (EasyCollectionUtil.isEmpty(aggregationValue.getAggregateValues())) {
                Comparable<?> value = this.getAggregationValue(streamResultSet, aggregationValue.getColumnIndex());
                comparables.add(value);
            } else {
                for (AggregateValue aggregateValue : aggregationValue.getAggregateValues()) {
                    Comparable<?> value = this.getAggregationValue(streamResultSet, aggregateValue.getColumnIndex());
                    comparables.add(value);
                }
            }
            aggregationValue.getAggregationUnit().merge(comparables);
        }
    }

    private Comparable<?> getAggregationValue(StreamResultSet streamResultSet, int columnIndex) throws SQLException {
        Object result = streamResultSet.getObject(columnIndex + 1);
        if (null == result || result instanceof Comparable) {
            return (Comparable)result;
        }
        throw new EasyQuerySQLCommandException("aggregation value must implements comparable");
    }

    private void setAggregationValueToMemoryRow(StreamMergeContext streamMergeContext, Map<GroupValue, MemoryResultSetRow> dataMap, Map<GroupValue, List<AggregateValue>> aggregationMap) throws SQLException {
        for (Map.Entry<GroupValue, MemoryResultSetRow> dataKv : dataMap.entrySet()) {
            List<AggregateValue> aggregateValues = aggregationMap.get(dataKv.getKey());
            for (AggregateValue aggregateValue : aggregateValues) {
                dataKv.getValue().setValue(aggregateValue.getColumnIndex() + 1, aggregateValue.getAggregationUnit().getResult());
            }
        }
    }

    private List<AggregateValue> createAggregationUnitValues() {
        List<SQLSegment> sqlSegments = this.streamMergeContext.getSelectColumns().getSQLSegments();
        ArrayList<AggregateValue> aggregationUnits = new ArrayList<AggregateValue>(this.columnCount);
        for (int i = 0; i < sqlSegments.size(); ++i) {
            SQLSegment sqlSegment = sqlSegments.get(i);
            boolean aggregateColumn = EasySQLSegmentUtil.isAggregateColumn(sqlSegment);
            if (!aggregateColumn) continue;
            MaybeAggregateColumnSegment maybeAggregateColumnSegment = (MaybeAggregateColumnSegment)sqlSegment;
            AggregateValue aggregateValue = new AggregateValue(i, AggregationUnitFactory.create(maybeAggregateColumnSegment.getAggregationType()));
            if (maybeAggregateColumnSegment instanceof FuncColumnSegment && Objects.equals((Object)AggregationType.AVG, (Object)maybeAggregateColumnSegment.getAggregationType())) {
                Map<AggregationType, ColumnIndexFuncColumnSegment> aggregationTypeFuncColumnSegmentMap = this.streamMergeContext.getGroupMergeContext().getColumnMapping().get(maybeAggregateColumnSegment);
                if (aggregationTypeFuncColumnSegmentMap == null) {
                    throw new UnsupportedOperationException("not found sum or count projects, avg column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                }
                ColumnIndexFuncColumnSegment countAvgColumnSegment = aggregationTypeFuncColumnSegmentMap.get((Object)AggregationType.COUNT);
                if (countAvgColumnSegment == null) {
                    throw new UnsupportedOperationException("not found count projects, avg column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                }
                AggregateValue avgCountAggregateValue = new AggregateValue(countAvgColumnSegment.getColumnIndex(), AggregationUnitFactory.create(countAvgColumnSegment.getFuncColumnSegment().getAggregationType()));
                aggregateValue.addAggregateValue(avgCountAggregateValue);
                ColumnIndexFuncColumnSegment sumAvgColumnSegment = aggregationTypeFuncColumnSegmentMap.get((Object)AggregationType.SUM);
                if (sumAvgColumnSegment == null) {
                    throw new UnsupportedOperationException("not found sum projects, avg column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
                }
                AggregateValue sumCountAggregateValue = new AggregateValue(sumAvgColumnSegment.getColumnIndex(), AggregationUnitFactory.create(sumAvgColumnSegment.getFuncColumnSegment().getAggregationType()));
                aggregateValue.addAggregateValue(sumCountAggregateValue);
            }
            aggregationUnits.add(aggregateValue);
        }
        return aggregationUnits;
    }
}

