/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.single;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.AbstractInMemoryStreamMergeResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.ConstMemoryResultSetRow;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.impl.memory.row.MemoryResultSetRow;
import com.easy.query.core.sharding.context.StreamMergeContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractSingleInMemoryStreamMergeResultSet
extends AbstractInMemoryStreamMergeResultSet {
    public AbstractSingleInMemoryStreamMergeResultSet(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        super(streamMergeContext, streamResultSets);
    }

    @Override
    protected List<MemoryResultSetRow> init(StreamMergeContext streamMergeContext, List<StreamResultSet> streamResultSets) throws SQLException {
        int columnCount = this.metaData.getColumnCount();
        if (columnCount != 1) {
            throw new SQLException("column count " + columnCount + " !=1");
        }
        Object resultValue = this.resultValue();
        Object defaultValue = this.defaultValue();
        ConstMemoryResultSetRow resultRow = null;
        ConstMemoryResultSetRow defaultRow = null;
        block14: for (StreamResultSet resultSet : streamResultSets) {
            try {
                StreamResultSet streamResultSet = resultSet;
                Throwable throwable = null;
                try {
                    if (resultRow != null) continue;
                    while (streamResultSet.next()) {
                        boolean isResult = Objects.equals(streamResultSet.getLong(1), resultValue);
                        if (isResult) {
                            resultRow = new ConstMemoryResultSetRow(resultValue);
                            continue block14;
                        }
                        if (defaultRow != null) continue;
                        defaultRow = new ConstMemoryResultSetRow(defaultValue);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (streamResultSet == null) continue;
                    if (throwable != null) {
                        try {
                            streamResultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    streamResultSet.close();
                }
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        ArrayList<MemoryResultSetRow> list = new ArrayList<MemoryResultSetRow>(1);
        if (resultRow != null) {
            list.add(resultRow);
        } else if (defaultRow != null) {
            list.add(new ConstMemoryResultSetRow(defaultValue));
        }
        return list;
    }

    protected abstract Object resultValue();

    protected abstract Object defaultValue();
}

