/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.reader;

import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.PartitionResult;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.JdbcProperty;
import com.easy.query.core.basic.jdbc.executor.internal.reader.DataReader;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.util.EasyJdbcExecutorUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.sql.SQLException;
import java.util.Objects;

public class PartitionByPropertyDataReader
implements DataReader {
    private final ResultColumnMetadata resultColumnMetadata;

    public PartitionByPropertyDataReader(ResultColumnMetadata resultColumnMetadata) {
        Objects.requireNonNull(resultColumnMetadata, "resultColumnMetadata can not be null.");
        this.resultColumnMetadata = resultColumnMetadata;
    }

    @Override
    public <TBean> void readTo(TBean entity, StreamResultSet streamResultSet) throws SQLException {
        JdbcTypeHandler handler = this.resultColumnMetadata.getJdbcTypeHandler();
        JdbcProperty jdbcProperty = this.resultColumnMetadata.getJdbcProperty();
        Object value = EasyJdbcExecutorUtil.fromValue(this.resultColumnMetadata, handler.getValue(jdbcProperty, streamResultSet));
        if (EasyStringUtil.startsWith(this.resultColumnMetadata.getPropertyName(), "__partition__")) {
            this.resultColumnMetadata.setValue(entity, value);
        } else {
            PartitionResult partitionResult = (PartitionResult)entity;
            this.resultColumnMetadata.setValue(partitionResult.getEntity(), value);
        }
    }
}

