/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.parameter;

import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.basic.jdbc.parameter.BeanSQLParameter;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyBeanUtil;
import java.util.Objects;

public final class PropertyTrackSQLParameter
implements BeanSQLParameter {
    private final TableAvailable table;
    private final String propertyName;
    private final QueryRuntimeContext runtimeContext;
    private final TrackContext currentTrackContext;
    private Object bean;

    public PropertyTrackSQLParameter(TableAvailable table, String propertyName, QueryRuntimeContext runtimeContext) {
        TrackContext currentTrackContext = runtimeContext.getTrackManager().getCurrentTrackContext();
        Objects.requireNonNull(currentTrackContext, "PropertyTrackSQLParameter track context is null");
        this.table = table;
        this.propertyName = propertyName;
        this.runtimeContext = runtimeContext;
        this.currentTrackContext = currentTrackContext;
    }

    @Override
    public TableAvailable getTableOrNull() {
        return this.table;
    }

    @Override
    public Object getValue() {
        if (this.bean == null) {
            throw new EasyQueryException("cant get sql parameter value," + this.table.getEntityMetadata().getEntityClass() + "." + this.propertyName + ",bean is null");
        }
        EntityMetadata entityMetadata = this.table.getEntityMetadata();
        EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(this.bean);
        Objects.requireNonNull(trackEntityState, "PropertyTrackSQLParameter trackEntityState is null");
        return EasyBeanUtil.getPropertyValue(trackEntityState.getOriginalValue(), entityMetadata, this.propertyName);
    }

    @Override
    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public String getPropertyNameOrNull() {
        return this.propertyName;
    }
}

