/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.types.handler;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.JdbcProperty;
import com.easy.query.core.basic.jdbc.types.EasyParameter;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import java.sql.SQLException;

public class FloatTypeHandler
implements JdbcTypeHandler {
    private static final float DEFAULT = 0.0f;

    @Override
    public Object getValue(JdbcProperty jdbcProperty, StreamResultSet streamResultSet) throws SQLException {
        float r = streamResultSet.getFloat(jdbcProperty.getJdbcIndex());
        if (r != 0.0f) {
            return Float.valueOf(r);
        }
        if (streamResultSet.wasNull()) {
            if (jdbcProperty.isPrimitive()) {
                return Float.valueOf(0.0f);
            }
            return null;
        }
        return Float.valueOf(r);
    }

    @Override
    public void setParameter(EasyParameter parameter) throws SQLException {
        parameter.getPs().setFloat(parameter.getIndex(), ((Float)parameter.getValue()).floatValue());
    }
}

