/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.thread;

import com.easy.query.core.basic.thread.EasyQueryThreadFactory;
import com.easy.query.core.basic.thread.ShardingExecutorService;
import com.easy.query.core.configuration.EasyQueryOption;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultEasyShardingExecutorService
implements ShardingExecutorService {
    private static final String DEFAULT_NAME_PREFIX = "SHARDING_EXECUTOR_";
    private final ExecutorService shardingExecutor;

    public DefaultEasyShardingExecutorService(EasyQueryOption easyQueryOption) {
        this.shardingExecutor = this.createExecutorService(easyQueryOption);
    }

    private ExecutorService createExecutorService(EasyQueryOption easyQueryOption) {
        int executorMaximumPoolSize = easyQueryOption.getExecutorMaximumPoolSize();
        EasyQueryThreadFactory easyShardingThreadFactory = new EasyQueryThreadFactory(DEFAULT_NAME_PREFIX);
        if (executorMaximumPoolSize <= 0) {
            return Executors.newCachedThreadPool(easyShardingThreadFactory);
        }
        int executorCorePoolSize = easyQueryOption.getExecutorCorePoolSize();
        int executorQueueSize = easyQueryOption.getExecutorQueueSize();
        return new ThreadPoolExecutor(executorCorePoolSize, executorMaximumPoolSize, 60000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(executorQueueSize), easyShardingThreadFactory);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.shardingExecutor;
    }
}

