/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.thread;

import com.easy.query.core.exception.EasyQueryFutureInvokeSQLException;
import com.easy.query.core.exception.EasyQueryTimeoutSQLException;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FuturesInvoker<TResult>
implements Closeable {
    private final List<Future<TResult>> futures;

    public FuturesInvoker(List<Future<TResult>> futures) {
        this.futures = futures;
    }

    public List<TResult> get(long timeoutMillis) throws SQLException {
        ArrayList<TResult> results = new ArrayList<TResult>(this.futures.size());
        long start = System.currentTimeMillis();
        long constTime = 0L;
        for (Future<TResult> future : this.futures) {
            try {
                if (future.isDone()) {
                    results.add(future.get());
                    continue;
                }
                if (timeoutMillis < constTime) {
                    throw new EasyQueryTimeoutSQLException("sharding query time out");
                }
                results.add(future.get(timeoutMillis - constTime, TimeUnit.MILLISECONDS));
                constTime = System.currentTimeMillis() - start;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new EasyQueryFutureInvokeSQLException(e);
            }
            catch (TimeoutException e) {
                throw new EasyQueryTimeoutSQLException(e);
            }
        }
        return results;
    }

    @Override
    public void close() {
        for (Future<TResult> future : this.futures) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
    }
}

