/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.common;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LinkedCaseInsensitiveMap<V>
extends LinkedHashMap<String, V> {
    private static final long serialVersionUID = 7171102532087849030L;
    private final HashMap<String, String> caseInsensitiveKeys;
    private final Locale locale;

    public LinkedCaseInsensitiveMap() {
        this(12, Locale.ENGLISH);
    }

    public LinkedCaseInsensitiveMap(Locale locale) {
        this(12, locale);
    }

    public LinkedCaseInsensitiveMap(int expectedSize, Locale locale) {
        super(expectedSize);
        this.caseInsensitiveKeys = this.newHashMap(expectedSize);
        this.locale = locale;
    }

    @Override
    public <Key, Value> HashMap<Key, Value> newHashMap(int expectedSize) {
        return new HashMap((int)((float)expectedSize / 0.75f), 0.75f);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String lowerCase = key.toString().toLowerCase(this.locale);
            String realKey = this.caseInsensitiveKeys.get(lowerCase);
            return realKey != null;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String realKey = this.caseInsensitiveKeys.get(key.toString().toLowerCase(this.locale));
            return super.get(realKey);
        }
        return null;
    }

    @Override
    public Set<String> keySet() {
        return this.caseInsensitiveKeys.keySet();
    }

    @Override
    public V put(String key, V value) {
        String oldKey = this.caseInsensitiveKeys.put(key.toLowerCase(this.locale), key);
        Object oldValue = super.remove(oldKey);
        super.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            String key = entry.getKey();
            V value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public V remove(Object key) {
        String realKey = this.caseInsensitiveKeys.remove(key.toString().toLowerCase(this.locale));
        return super.remove(realKey);
    }
}

