/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.common.bean;

import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.common.bean.FastBeanProperty;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.util.EasyClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class ReflectBean
implements FastBean {
    private final Class<?> entityClass;

    public ReflectBean(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public Property<Object, ?> getBeanGetter(FastBeanProperty prop) {
        return this.getReflectGetProperty(prop);
    }

    public Property<Object, ?> getReflectGetProperty(FastBeanProperty prop) {
        Method readMethod = prop.getReadMethod();
        return bean -> {
            try {
                return readMethod.invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new EasyQueryException(e);
            }
        };
    }

    @Override
    public PropertySetterCaller<Object> getBeanSetter(FastBeanProperty prop) {
        return this.getReflectSetProperty(prop);
    }

    public PropertySetterCaller<Object> getReflectSetProperty(FastBeanProperty prop) {
        Method setter = EasyClassUtil.getWriteMethodOrNull(prop, this.entityClass);
        if (setter == null) {
            return (bean, value) -> {};
        }
        return (bean, value) -> {
            try {
                setter.invoke(bean, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new EasyQueryException("Cannot set " + prop.getName() + ": " + e.getMessage());
            }
        };
    }

    @Override
    public Supplier<Object> getBeanConstructorCreator() {
        return () -> EasyClassUtil.newInstance(this.entityClass);
    }
}

