/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.common.cache;

import com.easy.query.core.common.cache.Cache;
import com.easy.query.core.util.EasyMapUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DefaultMemoryCache<K, V>
implements Cache<K, V> {
    private final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public void put(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public void clearAll() {
        this.map.clear();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return EasyMapUtil.computeIfAbsent(this.map, key, mappingFunction);
    }
}

