/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.configuration;

import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.EasyQueryReplicaOption;
import com.easy.query.core.configuration.EasyQueryShardingOption;
import com.easy.query.core.enums.RelationTableAppendEnum;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.enums.ShardingQueryInTransactionEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;

public class EasyQueryOptionBuilder {
    private boolean deleteThrowError = true;
    private SQLExecuteStrategyEnum insertStrategy = SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS;
    private SQLExecuteStrategyEnum updateStrategy = SQLExecuteStrategyEnum.ALL_COLUMNS;
    private int maxShardingQueryLimit = 5;
    private int executorMaximumPoolSize = 0;
    private int executorCorePoolSize;
    private ConnectionModeEnum connectionMode = ConnectionModeEnum.SYSTEM_AUTO;
    private boolean throwIfRouteNotMatch = true;
    private long shardingExecuteTimeoutMillis = 60000L;
    private EasyQueryReplicaOption replicaOption;
    private EasyQueryShardingOption shardingOption;
    private String defaultDataSourceName = "ds0";
    private int defaultDataSourceMergePoolSize = 0;
    private boolean queryLargeColumn = true;
    private int maxShardingRouteCount = 128;
    private int executorQueueSize = 1024;
    private long multiConnWaitTimeoutMillis = 5000L;
    private boolean warningBusy = true;
    private int insertBatchThreshold = 1024;
    private int updateBatchThreshold = 1024;
    private boolean printSql = true;
    private boolean printNavSql = true;
    private boolean startTimeJob = false;
    private boolean defaultTrack = false;
    private int relationGroupSize = 512;
    private boolean keepNativeStyle = false;
    private long reverseOffsetThreshold = 0L;
    private boolean warningColumnMiss = true;
    private int shardingFetchSize = 1000;
    private boolean mapToBeanStrict = true;
    private String defaultSchema = null;
    private long resultSizeLimit = -1L;
    private ShardingQueryInTransactionEnum shardingQueryInTransaction;
    private RelationTableAppendEnum relationTableAppend;

    public EasyQueryOptionBuilder() {
        this.executorCorePoolSize = Math.min(Runtime.getRuntime().availableProcessors(), 4);
        this.shardingQueryInTransaction = ShardingQueryInTransactionEnum.SERIALIZABLE;
        this.relationTableAppend = RelationTableAppendEnum.SMART;
    }

    public void setDeleteThrowError(boolean deleteThrowError) {
        this.deleteThrowError = deleteThrowError;
    }

    public void setInsertStrategy(SQLExecuteStrategyEnum insertStrategy) {
        this.insertStrategy = insertStrategy;
    }

    public void setUpdateStrategy(SQLExecuteStrategyEnum updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void setConnectionMode(ConnectionModeEnum connectionMode) {
        this.connectionMode = connectionMode;
    }

    public void setMaxShardingQueryLimit(int maxShardingQueryLimit) {
        this.maxShardingQueryLimit = maxShardingQueryLimit;
    }

    public void setExecutorMaximumPoolSize(int executorMaximumPoolSize) {
        this.executorMaximumPoolSize = executorMaximumPoolSize;
    }

    public void setExecutorCorePoolSize(int executorCorePoolSize) {
        this.executorCorePoolSize = executorCorePoolSize;
    }

    public void setThrowIfRouteNotMatch(boolean throwIfRouteNotMatch) {
        this.throwIfRouteNotMatch = throwIfRouteNotMatch;
    }

    public void setShardingExecuteTimeoutMillis(long shardingExecuteTimeoutMillis) {
        this.shardingExecuteTimeoutMillis = shardingExecuteTimeoutMillis;
    }

    public void setReplicaOption(EasyQueryReplicaOption replicaOption) {
        this.replicaOption = replicaOption;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public void setShardingOption(EasyQueryShardingOption shardingOption) {
        this.shardingOption = shardingOption;
    }

    public boolean isUseReplica() {
        return this.replicaOption != null;
    }

    public void setQueryLargeColumn(boolean queryLargeColumn) {
        this.queryLargeColumn = queryLargeColumn;
    }

    public void setMaxShardingRouteCount(int maxShardingRouteCount) {
        this.maxShardingRouteCount = maxShardingRouteCount;
    }

    public void setExecutorQueueSize(int executorQueueSize) {
        this.executorQueueSize = executorQueueSize;
    }

    public void setDefaultDataSourceMergePoolSize(int defaultDataSourceMergePoolSize) {
        this.defaultDataSourceMergePoolSize = defaultDataSourceMergePoolSize;
    }

    public void setMultiConnWaitTimeoutMillis(long multiConnWaitTimeoutMillis) {
        this.multiConnWaitTimeoutMillis = multiConnWaitTimeoutMillis;
    }

    public void setWarningBusy(boolean warningBusy) {
        this.warningBusy = warningBusy;
    }

    public void setInsertBatchThreshold(int insertBatchThreshold) {
        this.insertBatchThreshold = insertBatchThreshold;
    }

    public void setUpdateBatchThreshold(int updateBatchThreshold) {
        this.updateBatchThreshold = updateBatchThreshold;
    }

    public void setPrintSql(boolean printSql) {
        this.printSql = printSql;
    }

    public void setPrintNavSql(boolean printNavSql) {
        this.printNavSql = printNavSql;
    }

    public void setStartTimeJob(boolean startTimeJob) {
        this.startTimeJob = startTimeJob;
    }

    public void setDefaultTrack(boolean defaultTrack) {
        this.defaultTrack = defaultTrack;
    }

    public void setRelationGroupSize(int relationGroupSize) {
        this.relationGroupSize = relationGroupSize;
    }

    public void setKeepNativeStyle(boolean keepNativeStyle) {
        this.keepNativeStyle = keepNativeStyle;
    }

    public void setReverseOffsetThreshold(long reverseOffsetThreshold) {
        this.reverseOffsetThreshold = reverseOffsetThreshold;
    }

    public void setWarningColumnMiss(boolean warningColumnMiss) {
        this.warningColumnMiss = warningColumnMiss;
    }

    public void setShardingFetchSize(int shardingFetchSize) {
        this.shardingFetchSize = shardingFetchSize;
    }

    public void setMapToBeanStrict(boolean mapToBeanStrict) {
        this.mapToBeanStrict = mapToBeanStrict;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void setResultSizeLimit(long resultSizeLimit) {
        this.resultSizeLimit = resultSizeLimit;
    }

    public void setShardingQueryInTransaction(ShardingQueryInTransactionEnum shardingQueryInTransaction) {
        this.shardingQueryInTransaction = shardingQueryInTransaction;
    }

    public void setRelationTableAppend(RelationTableAppendEnum relationTableAppend) {
        this.relationTableAppend = relationTableAppend;
    }

    public EasyQueryOption build() {
        return new EasyQueryOption(this.deleteThrowError, this.insertStrategy, this.updateStrategy, this.connectionMode, this.maxShardingQueryLimit, this.executorMaximumPoolSize, this.executorCorePoolSize, this.throwIfRouteNotMatch, this.shardingExecuteTimeoutMillis, this.shardingOption, this.replicaOption, this.defaultDataSourceName, this.defaultDataSourceMergePoolSize, this.queryLargeColumn, this.maxShardingRouteCount, this.executorQueueSize, this.multiConnWaitTimeoutMillis, this.warningBusy, this.insertBatchThreshold, this.updateBatchThreshold, this.printSql, this.startTimeJob, this.defaultTrack, this.relationGroupSize, this.keepNativeStyle, this.reverseOffsetThreshold, this.warningColumnMiss, this.shardingFetchSize, this.mapToBeanStrict, this.defaultSchema, this.resultSizeLimit, this.printNavSql, this.shardingQueryInTransaction, this.relationTableAppend);
    }
}

