/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.configuration;

import com.easy.query.core.basic.extension.conversion.ColumnValueSQLConverter;
import com.easy.query.core.basic.extension.conversion.EnumValueAutoConverter;
import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.encryption.EncryptionStrategy;
import com.easy.query.core.basic.extension.generated.GeneratedKeySQLColumnGenerator;
import com.easy.query.core.basic.extension.generated.PrimaryKeyGenerator;
import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteStrategy;
import com.easy.query.core.basic.extension.logicdel.LogicDeleteStrategyEnum;
import com.easy.query.core.basic.extension.logicdel.impl.BooleanLogicDeleteStrategy;
import com.easy.query.core.basic.extension.logicdel.impl.LocalDateLogicDeleteStrategy;
import com.easy.query.core.basic.extension.logicdel.impl.LocalDateTimeLogicDeleteStrategy;
import com.easy.query.core.basic.extension.logicdel.impl.LongTimestampLogicDeleteStrategy;
import com.easy.query.core.basic.extension.navigate.NavigateExtraFilterStrategy;
import com.easy.query.core.basic.extension.navigate.NavigateValueSetter;
import com.easy.query.core.basic.extension.version.VersionIntStrategy;
import com.easy.query.core.basic.extension.version.VersionLongStrategy;
import com.easy.query.core.basic.extension.version.VersionStrategy;
import com.easy.query.core.basic.extension.version.VersionTimestampStrategy;
import com.easy.query.core.basic.extension.version.VersionUUIDStrategy;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.configuration.nameconversion.NameConversion;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.job.EasyTimeJobManager;
import com.easy.query.core.job.TimeJob;
import com.easy.query.core.sharding.initializer.ShardingInitializer;
import com.easy.query.core.sharding.initializer.UnShardingInitializer;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class QueryConfiguration {
    private static final LogicDeleteStrategy BOOL_LOGIC_DELETE = new BooleanLogicDeleteStrategy();
    private static final LogicDeleteStrategy TIMESTAMP_LOGIC_DELETE = new LongTimestampLogicDeleteStrategy();
    private static final LogicDeleteStrategy LOCAL_DATE_TIME_LOGIC_DELETE = new LocalDateTimeLogicDeleteStrategy();
    private static final LogicDeleteStrategy LOCAL_DATE_LOGIC_DELETE = new LocalDateLogicDeleteStrategy();
    private final EasyQueryOption easyQueryOption;
    private final NameConversion nameConversion;
    private final EasyTimeJobManager easyTimeJobManager;
    private final SQLKeyword SQLKeyWord;
    private Map<String, Interceptor> interceptorMap = new ConcurrentHashMap<String, Interceptor>();
    private Map<String, LogicDeleteStrategy> globalLogicDeleteStrategyMap = new ConcurrentHashMap<String, LogicDeleteStrategy>();
    private Map<Class<? extends NavigateExtraFilterStrategy>, NavigateExtraFilterStrategy> navigateExtraFilterStrategyMap = new ConcurrentHashMap<Class<? extends NavigateExtraFilterStrategy>, NavigateExtraFilterStrategy>();
    private Map<Class<? extends NavigateValueSetter>, NavigateValueSetter> navigateValueSetterMap = new ConcurrentHashMap<Class<? extends NavigateValueSetter>, NavigateValueSetter>();
    private Map<Class<? extends EncryptionStrategy>, EncryptionStrategy> easyEncryptionStrategyMap = new ConcurrentHashMap<Class<? extends EncryptionStrategy>, EncryptionStrategy>();
    private Map<Class<? extends VersionStrategy>, VersionStrategy> easyVersionStrategyMap = new ConcurrentHashMap<Class<? extends VersionStrategy>, VersionStrategy>();
    private Map<Class<? extends ShardingInitializer>, ShardingInitializer> shardingInitializerMap = new ConcurrentHashMap<Class<? extends ShardingInitializer>, ShardingInitializer>();
    private Map<Class<? extends ValueConverter<?, ?>>, ValueConverter<?, ?>> valueConverterMap = new ConcurrentHashMap();
    private List<EnumValueAutoConverter<?, ?>> enumValueAutoConverters = new CopyOnWriteArrayList();
    private Map<Class<? extends ColumnValueSQLConverter>, ColumnValueSQLConverter> columnValueSQLConverterMap = new ConcurrentHashMap<Class<? extends ColumnValueSQLConverter>, ColumnValueSQLConverter>();
    private Map<Class<? extends GeneratedKeySQLColumnGenerator>, GeneratedKeySQLColumnGenerator> generatedSQLColumnGeneratorMap = new ConcurrentHashMap<Class<? extends GeneratedKeySQLColumnGenerator>, GeneratedKeySQLColumnGenerator>();
    private Map<Class<? extends PrimaryKeyGenerator>, PrimaryKeyGenerator> primaryKeyGeneratorMap = new ConcurrentHashMap<Class<? extends PrimaryKeyGenerator>, PrimaryKeyGenerator>();

    public QueryConfiguration(EasyQueryOption easyQueryOption, SQLKeyword SQLKeyWord, NameConversion nameConversion, EasyTimeJobManager easyTimeJobManager) {
        this.easyQueryOption = easyQueryOption;
        this.SQLKeyWord = SQLKeyWord;
        this.nameConversion = nameConversion;
        this.easyTimeJobManager = easyTimeJobManager;
        this.easyVersionStrategyMap.put(VersionIntStrategy.class, new VersionIntStrategy());
        this.easyVersionStrategyMap.put(VersionLongStrategy.class, new VersionLongStrategy());
        this.easyVersionStrategyMap.put(VersionUUIDStrategy.class, new VersionUUIDStrategy());
        this.easyVersionStrategyMap.put(VersionTimestampStrategy.class, new VersionTimestampStrategy());
        this.shardingInitializerMap.put(UnShardingInitializer.class, UnShardingInitializer.INSTANCE);
    }

    public boolean deleteThrow() {
        return this.easyQueryOption.isDeleteThrowError();
    }

    public NameConversion getNameConversion() {
        return this.nameConversion;
    }

    public SQLKeyword getDialect() {
        return this.SQLKeyWord;
    }

    public void applyInterceptor(Interceptor easyInterceptor) {
        String interceptorName = easyInterceptor.name();
        if (EasyStringUtil.isBlank(interceptorName)) {
            throw new EasyQueryException("interceptor :[" + EasyClassUtil.getInstanceSimpleName(easyInterceptor) + "] cant get name");
        }
        if (this.interceptorMap.containsKey(interceptorName)) {
            throw new EasyQueryException("global interceptor:" + interceptorName + ",repeat");
        }
        this.interceptorMap.put(interceptorName, easyInterceptor);
    }

    public Interceptor getEasyInterceptor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("cant get global interceptor,name is null");
        }
        return this.interceptorMap.get(name);
    }

    public Collection<Interceptor> getEasyInterceptors() {
        return this.interceptorMap.values();
    }

    public void applyLogicDeleteStrategy(LogicDeleteStrategy globalLogicDeleteStrategy) {
        String strategy = globalLogicDeleteStrategy.getStrategy();
        if (this.globalLogicDeleteStrategyMap.containsKey(strategy)) {
            throw new EasyQueryException("global logic delete strategy:" + strategy + ",repeat");
        }
        this.globalLogicDeleteStrategyMap.put(strategy, globalLogicDeleteStrategy);
    }

    public void applyNavigateExtraFilterStrategy(NavigateExtraFilterStrategy navigateExtraFilterStrategy) {
        Objects.requireNonNull(navigateExtraFilterStrategy, "navigateExtraFilterStrategy is null");
        if (this.navigateExtraFilterStrategyMap.containsKey(navigateExtraFilterStrategy.getClass())) {
            throw new EasyQueryException("navigate extra filter strategy:" + EasyClassUtil.getSimpleName(navigateExtraFilterStrategy.getClass()) + ",repeat");
        }
        this.navigateExtraFilterStrategyMap.put(navigateExtraFilterStrategy.getClass(), navigateExtraFilterStrategy);
    }

    public NavigateExtraFilterStrategy getNavigateExtraFilterStrategy(Class<? extends NavigateExtraFilterStrategy> strategy) {
        return this.navigateExtraFilterStrategyMap.get(strategy);
    }

    public void applyNavigateValueSetter(NavigateValueSetter navigateValueSetter) {
        Objects.requireNonNull(navigateValueSetter, "navigateValueSetter is null");
        if (this.navigateValueSetterMap.containsKey(navigateValueSetter.getClass())) {
            throw new EasyQueryException("navigate value setter:" + EasyClassUtil.getSimpleName(navigateValueSetter.getClass()) + ",repeat");
        }
        Class nvClass = (Class)EasyObjectUtil.typeCastNullable(navigateValueSetter.getClass());
        this.navigateValueSetterMap.put(nvClass, navigateValueSetter);
    }

    public NavigateValueSetter getNavigateValueSetter(Class<? extends NavigateValueSetter> valueSetter) {
        return this.navigateValueSetterMap.get(valueSetter);
    }

    public LogicDeleteStrategy getLogicDeleteStrategy(String strategy) {
        return this.globalLogicDeleteStrategyMap.get(strategy);
    }

    public LogicDeleteStrategy getLogicDeleteStrategyNotNull(String strategy) {
        LogicDeleteStrategy globalLogicDeleteStrategy = this.getLogicDeleteStrategy(strategy);
        if (globalLogicDeleteStrategy == null) {
            throw new EasyQueryException("easy logic delete strategy not found. strategy:" + strategy);
        }
        return globalLogicDeleteStrategy;
    }

    public LogicDeleteStrategy getSysLogicDeleteStrategyNotNull(LogicDeleteStrategyEnum strategy) {
        if (Objects.equals((Object)LogicDeleteStrategyEnum.BOOLEAN, (Object)strategy)) {
            return BOOL_LOGIC_DELETE;
        }
        if (Objects.equals((Object)LogicDeleteStrategyEnum.DELETE_LONG_TIMESTAMP, (Object)strategy)) {
            return TIMESTAMP_LOGIC_DELETE;
        }
        if (Objects.equals((Object)LogicDeleteStrategyEnum.LOCAL_DATE_TIME, (Object)strategy)) {
            return LOCAL_DATE_TIME_LOGIC_DELETE;
        }
        if (Objects.equals((Object)LogicDeleteStrategyEnum.LOCAL_DATE, (Object)strategy)) {
            return LOCAL_DATE_LOGIC_DELETE;
        }
        throw new EasyQueryException("easy logic delete strategy not found. strategy:" + (Object)((Object)strategy));
    }

    public void applyEncryptionStrategy(EncryptionStrategy encryptionStrategy) {
        Class<?> strategyClass = encryptionStrategy.getClass();
        if (this.easyEncryptionStrategyMap.containsKey(strategyClass)) {
            throw new EasyQueryException("easy encryption strategy:" + EasyClassUtil.getSimpleName(strategyClass) + ",repeat");
        }
        this.easyEncryptionStrategyMap.put(strategyClass, encryptionStrategy);
    }

    public EncryptionStrategy getEasyEncryptionStrategy(Class<? extends EncryptionStrategy> strategy) {
        return this.easyEncryptionStrategyMap.get(strategy);
    }

    public boolean containEasyEncryptionStrategy(Class<? extends EncryptionStrategy> strategy) {
        return this.getEasyEncryptionStrategy(strategy) != null;
    }

    public EncryptionStrategy getEasyEncryptionStrategyNotNull(Class<? extends EncryptionStrategy> strategy) {
        EncryptionStrategy easyEncryptionStrategy = this.getEasyEncryptionStrategy(strategy);
        if (easyEncryptionStrategy == null) {
            throw new EasyQueryException("easy encryption strategy not found. strategy:" + EasyClassUtil.getSimpleName(strategy));
        }
        return easyEncryptionStrategy;
    }

    public void applyEasyVersionStrategy(VersionStrategy versionStrategy) {
        Class<?> strategyClass = versionStrategy.getClass();
        if (this.easyVersionStrategyMap.containsKey(strategyClass)) {
            throw new EasyQueryException("easy version strategy:" + EasyClassUtil.getSimpleName(strategyClass) + ",repeat");
        }
        this.easyVersionStrategyMap.put(strategyClass, versionStrategy);
    }

    public VersionStrategy getEasyVersionStrategyOrNull(Class<? extends VersionStrategy> strategy) {
        return this.easyVersionStrategyMap.get(strategy);
    }

    public boolean containEasyVersionStrategy(Class<? extends VersionStrategy> strategy) {
        return this.getEasyVersionStrategyOrNull(strategy) != null;
    }

    public VersionStrategy getEasyVersionStrategyNotNull(Class<? extends VersionStrategy> strategy) {
        VersionStrategy easyVersionStrategy = this.getEasyVersionStrategyOrNull(strategy);
        if (easyVersionStrategy == null) {
            throw new EasyQueryException("easy version strategy not found. strategy:" + EasyClassUtil.getSimpleName(strategy));
        }
        return easyVersionStrategy;
    }

    public EasyQueryOption getEasyQueryOption() {
        return this.easyQueryOption;
    }

    public void applyShardingInitializer(ShardingInitializer shardingInitializer) {
        Class<?> initializerClass = shardingInitializer.getClass();
        if (this.shardingInitializerMap.containsKey(initializerClass)) {
            throw new EasyQueryException("easy sharding initializer:" + EasyClassUtil.getSimpleName(initializerClass) + ",repeat");
        }
        this.shardingInitializerMap.put(initializerClass, shardingInitializer);
        if (shardingInitializer instanceof TimeJob) {
            this.easyTimeJobManager.add((TimeJob)((Object)shardingInitializer));
        }
    }

    public ShardingInitializer getEasyShardingInitializerOrNull(Class<? extends ShardingInitializer> initializer) {
        return this.shardingInitializerMap.get(initializer);
    }

    public void applyValueConverter(ValueConverter<?, ?> valueConverter) {
        Class converterClass = (Class)EasyObjectUtil.typeCastNullable(valueConverter.getClass());
        if (this.valueConverterMap.containsKey(converterClass)) {
            throw new EasyQueryException("ValueConverter:" + EasyClassUtil.getSimpleName(converterClass) + ",repeat");
        }
        this.valueConverterMap.put(converterClass, valueConverter);
        if (EnumValueAutoConverter.class.isAssignableFrom(converterClass)) {
            EnumValueAutoConverter enumValueAutoConverter = (EnumValueAutoConverter)EasyObjectUtil.typeCastNullable(valueConverter);
            this.enumValueAutoConverters.add(enumValueAutoConverter);
        }
    }

    public List<EnumValueAutoConverter<?, ?>> getEnumValueAutoConverters() {
        return this.enumValueAutoConverters;
    }

    public ValueConverter<?, ?> getValueConverter(Class<? extends ValueConverter<?, ?>> converterClass) {
        return this.valueConverterMap.get(converterClass);
    }

    public void applyColumnValueSQLConverter(ColumnValueSQLConverter columnValueSQLConverter) {
        Class<?> columnValueSQLConverterClass = columnValueSQLConverter.getClass();
        if (this.columnValueSQLConverterMap.containsKey(columnValueSQLConverterClass)) {
            throw new EasyQueryException("column value sql converter:" + EasyClassUtil.getSimpleName(columnValueSQLConverterClass) + ",repeat");
        }
        this.columnValueSQLConverterMap.put(columnValueSQLConverterClass, columnValueSQLConverter);
    }

    public ColumnValueSQLConverter getColumnValueSQLConverter(Class<? extends ColumnValueSQLConverter> columnValueSQLConverterClass) {
        return this.columnValueSQLConverterMap.get(columnValueSQLConverterClass);
    }

    public void applyGeneratedKeySQLColumnGenerator(GeneratedKeySQLColumnGenerator generatedKeySQLColumnGenerator) {
        Class<?> generatedKeySQLColumnGeneratorClass = generatedKeySQLColumnGenerator.getClass();
        if (this.generatedSQLColumnGeneratorMap.containsKey(generatedKeySQLColumnGeneratorClass)) {
            throw new EasyQueryException("generated key sql column generator:" + EasyClassUtil.getSimpleName(generatedKeySQLColumnGeneratorClass) + ",repeat");
        }
        this.generatedSQLColumnGeneratorMap.put(generatedKeySQLColumnGeneratorClass, generatedKeySQLColumnGenerator);
    }

    public GeneratedKeySQLColumnGenerator getGeneratedKeySQLColumnGenerator(Class<? extends GeneratedKeySQLColumnGenerator> generatedKeySQLColumnGenerator) {
        return this.generatedSQLColumnGeneratorMap.get(generatedKeySQLColumnGenerator);
    }

    public void applyPrimaryKeyGenerator(PrimaryKeyGenerator primaryKeyGenerator) {
        Class<?> primaryKeyGeneratorClass = primaryKeyGenerator.getClass();
        if (this.primaryKeyGeneratorMap.containsKey(primaryKeyGeneratorClass)) {
            throw new EasyQueryException("primary key generator:" + EasyClassUtil.getSimpleName(primaryKeyGeneratorClass) + ",repeat");
        }
        this.primaryKeyGeneratorMap.put(primaryKeyGeneratorClass, primaryKeyGenerator);
    }

    public PrimaryKeyGenerator getPrimaryKeyGenerator(Class<? extends PrimaryKeyGenerator> primaryKeyGenerator) {
        return this.primaryKeyGeneratorMap.get(primaryKeyGenerator);
    }
}

