/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.configuration;

import com.easy.query.core.util.EasyStringUtil;
import java.util.Objects;
import javax.sql.DataSource;

public final class ShardingDataSource {
    private final String dataSourceName;
    private final DataSource dataSource;
    private final int dataSourceMergePoolSize;

    public ShardingDataSource(String dataSourceName, DataSource dataSource, int dataSourceMergePoolSize) {
        if (EasyStringUtil.isBlank(dataSourceName)) {
            throw new IllegalArgumentException("dataSourceName is empty");
        }
        if (dataSourceMergePoolSize <= 0) {
            throw new IllegalArgumentException("dataSourceMergePoolSize <= 0");
        }
        this.dataSourceName = dataSourceName;
        this.dataSource = dataSource;
        this.dataSourceMergePoolSize = dataSourceMergePoolSize;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getDataSourceMergePoolSize() {
        return this.dataSourceMergePoolSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardingDataSource that = (ShardingDataSource)o;
        return Objects.equals(this.dataSourceName, that.dataSourceName);
    }

    public int hashCode() {
        return Objects.hash(this.dataSourceName);
    }
}

