/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.configuration.bean.def;

import com.easy.query.core.configuration.bean.EasyMatcher;
import com.easy.query.core.configuration.bean.PropertyDescriptorResult;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.logging.nologging.NoLoggingImpl;
import com.easy.query.core.metadata.PropertyDescriptorFinder;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;

public class DefaultEasyMatcher
implements EasyMatcher {
    private static final Log log = LogFactory.getLog(DefaultEasyMatcher.class);
    private final PropertyDescriptorFinder propertyDescriptorFinder;

    public DefaultEasyMatcher(PropertyDescriptor[] propertyDescriptors) {
        this.propertyDescriptorFinder = new PropertyDescriptorFinder(propertyDescriptors);
    }

    @Override
    public PropertyDescriptorResult match(Class<?> entityClass, Field field) {
        String property = EasyStringUtil.toLowerCaseFirstOne(field.getName());
        PropertyDescriptor propertyDescriptor = this.propertyDescriptorFinder.find(property);
        if (propertyDescriptor == null) {
            propertyDescriptor = this.propertyDescriptorFinder.findIgnoreCase(property);
            if (propertyDescriptor != null) {
                String warningMessage = EasyClassUtil.getSimpleName(entityClass) + " filed:" + field.getName() + ",compare name:" + property + ",property name:" + propertyDescriptor.getName() + " If you want to use a non-standard Java bean, please set [propertyMode] to [same_as_entity].";
                if (log instanceof NoLoggingImpl) {
                    System.out.println("NoLogging:" + warningMessage);
                } else {
                    log.warn(warningMessage);
                }
            }
            return null;
        }
        return new PropertyDescriptorResult(property, propertyDescriptor);
    }
}

