/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.configuration.bean.entity;

import com.easy.query.core.configuration.bean.EasyMatcher;
import com.easy.query.core.configuration.bean.PropertyDescriptorResult;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EntityEasyMatcher
implements EasyMatcher {
    private final Map<String, List<PropertyDescriptor>> propertyDescriptorsMap = new HashMap<String, List<PropertyDescriptor>>();

    public EntityEasyMatcher(PropertyDescriptor[] propertyDescriptors) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            List list = this.propertyDescriptorsMap.computeIfAbsent(propertyDescriptor.getName().toLowerCase(Locale.ENGLISH), o -> new ArrayList());
            list.add(propertyDescriptor);
        }
    }

    private List<PropertyDescriptor> getPropertyDescriptorsByField(Field field) {
        List<PropertyDescriptor> list = this.propertyDescriptorsMap.get(field.getName().toLowerCase(Locale.ENGLISH));
        if (EasyCollectionUtil.isNotEmpty(list)) {
            return list;
        }
        if (EasyClassUtil.isBooleanBasic(field.getType()) && field.getName().startsWith("is") && EasyCollectionUtil.isNotEmpty(list = this.propertyDescriptorsMap.get(field.getName().substring(2).toLowerCase(Locale.ENGLISH)))) {
            return list;
        }
        return null;
    }

    @Override
    public PropertyDescriptorResult match(Class<?> entityClass, Field field) {
        List<PropertyDescriptor> list = this.getPropertyDescriptorsByField(field);
        if (EasyCollectionUtil.isEmpty(list)) {
            return null;
        }
        if (EasyCollectionUtil.isNotSingle(list)) {
            throw new EasyQueryInvalidOperationException(String.format("entity class:[%s] field name :[%s] at most one element in PropertyDescriptor array.", EasyClassUtil.getSimpleName(entityClass), field.getName()));
        }
        PropertyDescriptor first = EasyCollectionUtil.first(list);
        return new PropertyDescriptorResult(field.getName(), first);
    }
}

