/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.datasource;

import com.easy.query.core.common.SemaphoreReleaseOnlyOnce;
import com.easy.query.core.datasource.DataSourceUnit;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.exception.EasyQuerySQLException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class DefaultDataSourceUnit
implements DataSourceUnit {
    private static final Log log = LogFactory.getLog(DefaultDataSourceUnit.class);
    protected final String dataSourceName;
    protected final DataSource dataSource;
    protected final Semaphore semaphore;
    private final boolean warningBusy;

    public DefaultDataSourceUnit(String dataSourceName, DataSource dataSource, int mergePoolSize, boolean warningBusy) {
        this.dataSourceName = dataSourceName;
        this.dataSource = dataSource;
        this.semaphore = mergePoolSize <= 0 ? null : new Semaphore(mergePoolSize, true);
        this.warningBusy = warningBusy;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public List<Connection> getConnections(int count, long timeout, TimeUnit unit) throws SQLException {
        if (count <= 1) {
            Connection connection = this.getConnection(false);
            return Collections.singletonList(connection);
        }
        if (this.semaphore == null) {
            throw new EasyQueryInvalidOperationException("sharding table should set dataSourceName:[" + this.dataSourceName + "] dataSourcePool,current value <= 0.");
        }
        return this.getMergeConnections(count, timeout, unit);
    }

    @Override
    public Connection getConnection(long timeout, TimeUnit unit) throws SQLException {
        return this.getConnection(false);
    }

    protected Connection getConnection(boolean concurrency) throws SQLException {
        return this.dataSource.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Connection> getMergeConnections(int count, long timeout, TimeUnit unit) throws SQLException {
        SemaphoreReleaseOnlyOnce semaphoreReleaseOnlyOnce = this.tryAcquire(count, timeout, unit);
        if (semaphoreReleaseOnlyOnce == null) {
            throw new EasyQuerySQLException("dataSourceName:" + this.dataSourceName + " get connections:" + 1 + " busy.");
        }
        try {
            ArrayList<Connection> result = new ArrayList<Connection>(count);
            for (int i = 0; i < count; ++i) {
                Connection connection = this.getConnection(true);
                result.add(connection);
            }
            ArrayList<Connection> arrayList = result;
            return arrayList;
        }
        finally {
            semaphoreReleaseOnlyOnce.release();
        }
    }

    protected SemaphoreReleaseOnlyOnce tryAcquire(int count, long timeout, TimeUnit unit) {
        try {
            long startTime = this.warningBusy ? System.currentTimeMillis() : 0L;
            boolean acquire = this.semaphore.tryAcquire(count, timeout, unit);
            if (acquire) {
                long timeoutMillis;
                long endTime;
                long constTime;
                if (this.warningBusy && (double)(constTime = (endTime = System.currentTimeMillis()) - startTime) >= (double)(timeoutMillis = unit.toMillis(timeout)) * 0.8) {
                    log.warn("get connection use time:" + constTime + "(ms),timeout:" + timeoutMillis + "(ms). you can try increasing the connection pool size or reducing the number of access requests.");
                }
                return new SemaphoreReleaseOnlyOnce(count, this.semaphore);
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new EasyQueryException(e);
        }
    }
}

