/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.datasource.replica.connectors;

import com.easy.query.core.datasource.replica.ReplicaNode;
import com.easy.query.core.datasource.replica.connectors.ReplicaConnector;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;
import java.util.Objects;

public abstract class AbstractReplicaConnector
implements ReplicaConnector {
    protected final String dataSourceName;
    protected final List<ReplicaNode> replicaNodes;
    protected int length;

    public AbstractReplicaConnector(String dataSourceName, List<ReplicaNode> replicaNodes) {
        this.replicaNodes = replicaNodes;
        this.length = replicaNodes.size();
        this.dataSourceName = dataSourceName;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public synchronized boolean addReplicaNode(ReplicaNode replicaNode) {
        boolean any = EasyCollectionUtil.any(this.replicaNodes, o -> Objects.equals(o.getDataSourceUnit(), replicaNode.getDataSourceUnit()));
        if (any) {
            return false;
        }
        this.replicaNodes.add(replicaNode);
        return true;
    }
}

