/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.builder.impl;

import com.easy.query.core.basic.entity.EntityMappingRule;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.PartitionResult;
import com.easy.query.core.enums.EntityMetadataTypeEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.builder.impl.AbstractSelector;
import com.easy.query.core.expression.segment.ColumnSegment;
import com.easy.query.core.expression.segment.SQLEntityAliasSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.sql.builder.AnonymousEntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.List;

public abstract class AbstractAsSelector<TChain>
extends AbstractSelector<TChain> {
    protected final Class<?> resultClass;
    protected final EntityMetadata resultEntityMetadata;

    public AbstractAsSelector(EntityQueryExpressionBuilder entityQueryExpressionBuilder, SQLBuilderSegment sqlBuilderSegment, EntityMetadata resultEntityMetadata) {
        super(entityQueryExpressionBuilder, sqlBuilderSegment);
        this.resultEntityMetadata = resultEntityMetadata;
        this.resultClass = resultEntityMetadata.getEntityClass();
    }

    @Override
    protected TChain columnAnonymousAll(AnonymousEntityTableExpressionBuilder table) {
        if (PartitionResult.class.isAssignableFrom(this.resultEntityMetadata.getEntityClass())) {
            return super.columnAnonymousAll(table);
        }
        EntityQueryExpressionBuilder queryExpressionBuilder = this.getAnonymousTableQueryExpressionBuilder(table);
        if (EasySQLSegmentUtil.isNotEmpty(queryExpressionBuilder.getProjects())) {
            List<SQLSegment> sqlSegments = queryExpressionBuilder.getProjects().getSQLSegments();
            EntityMappingRule entityMappingRule = this.runtimeContext.getEntityMappingRule();
            for (SQLSegment sqlSegment : sqlSegments) {
                if (sqlSegment instanceof SQLEntityAliasSegment) {
                    ColumnSegment columnSegment;
                    SQLEntityAliasSegment sqlEntityAliasSegment = (SQLEntityAliasSegment)sqlSegment;
                    String propertyName = entityMappingRule.getAnonymousPropertyNameFromSQLSegment(sqlEntityAliasSegment, table.getEntityTable());
                    if (propertyName != null) {
                        if (this.resultEntityMetadata.getColumnOrNull(propertyName) != null) {
                            columnSegment = this.sqlSegmentFactory.createSelectColumnSegment(table.getEntityTable(), propertyName, this.expressionContext, sqlEntityAliasSegment.getAlias());
                            this.sqlBuilderSegment.append(columnSegment);
                            continue;
                        }
                        if (this.resultEntityMetadata.getEntityMetadataType() != EntityMetadataTypeEnum.MAP) continue;
                        columnSegment = this.sqlSegmentFactory.createAnonymousColumnSegment(table.getEntityTable(), this.expressionContext, sqlEntityAliasSegment.getAlias());
                        this.sqlBuilderSegment.append(columnSegment);
                        continue;
                    }
                    columnSegment = this.sqlSegmentFactory.createAnonymousColumnSegment(table.getEntityTable(), this.expressionContext, sqlEntityAliasSegment.getAlias());
                    this.sqlBuilderSegment.append(columnSegment);
                    continue;
                }
                throw new EasyQueryException("columnAll not found column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
            }
        }
        return this.castChain();
    }
}

