/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.builder.impl;

import com.easy.query.core.basic.entity.EntityMappingRule;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.core.ResultColumnInfo;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.CloneableSQLSegment;
import com.easy.query.core.expression.segment.ColumnSegment;
import com.easy.query.core.expression.segment.SQLEntityAliasSegment;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.sql.builder.AnonymousEntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.SQLAnonymousUnionEntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.include.ColumnIncludeExpression;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.IncludeNavigateExpression;
import com.easy.query.core.metadata.IncludeNavigateParams;
import com.easy.query.core.metadata.MapEntityMetadata;
import com.easy.query.core.metadata.NavigateJoinMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyRelationalUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractSelector<TChain> {
    protected final QueryRuntimeContext runtimeContext;
    protected final SQLSegmentFactory sqlSegmentFactory;
    protected final SQLBuilderSegment sqlBuilderSegment;
    protected final EntityQueryExpressionBuilder entityQueryExpressionBuilder;
    protected final ExpressionContext expressionContext;

    public AbstractSelector(EntityQueryExpressionBuilder entityQueryExpressionBuilder, SQLBuilderSegment sqlBuilderSegment) {
        this.entityQueryExpressionBuilder = entityQueryExpressionBuilder;
        this.expressionContext = entityQueryExpressionBuilder.getExpressionContext();
        this.runtimeContext = this.expressionContext.getRuntimeContext();
        this.sqlSegmentFactory = this.runtimeContext.getSQLSegmentFactory();
        this.sqlBuilderSegment = sqlBuilderSegment;
    }

    protected abstract TChain castChain();

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public EntityQueryExpressionBuilder getEntityQueryExpressionBuilder() {
        return this.entityQueryExpressionBuilder;
    }

    public TChain groupKeys(int index) {
        return this.groupKeysAs(index, null);
    }

    public TChain groupKeysAs(int index, String alias) {
        if (EasySQLSegmentUtil.isEmpty(this.entityQueryExpressionBuilder.getGroup())) {
            throw new EasyQueryInvalidOperationException("not found group in current expression builder");
        }
        List<SQLSegment> sqlSegments = this.entityQueryExpressionBuilder.getGroup().getSQLSegments();
        if (sqlSegments.size() <= index) {
            throw new EasyQueryInvalidOperationException("current expression builder group keys size:[" + sqlSegments.size() + "],not found keys index:[" + index + "]");
        }
        SQLSegment sqlSegment = sqlSegments.get(index);
        if (sqlSegment instanceof CloneableSQLSegment) {
            CloneableSQLSegment cloneableSQLSegment = ((CloneableSQLSegment)sqlSegment).cloneSQLColumnSegment();
            if (alias != null) {
                ResultColumnInfo resultColumnInfo = this.getResultColumnName(alias);
                CloneableSQLSegment sqlColumnAsSegment = this.sqlSegmentFactory.createSQLColumnAsSegment(cloneableSQLSegment, resultColumnInfo.getColumnAsName(), this.runtimeContext);
                this.sqlBuilderSegment.append(sqlColumnAsSegment);
            } else {
                this.sqlBuilderSegment.append(cloneableSQLSegment);
            }
        } else {
            throw new EasyQueryInvalidOperationException("group key not instanceof CloneableSQLSegment not support key quick select");
        }
        return this.castChain();
    }

    protected abstract ResultColumnInfo getResultColumnName(String var1);

    public TChain columnKeys(TableAvailable table) {
        Collection<String> keyProperties = table.getEntityMetadata().getKeyProperties();
        if (EasyCollectionUtil.isEmpty(keyProperties)) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName(table.getEntityClass()) + " not found keys");
        }
        for (String keyProperty : keyProperties) {
            this.column(table, keyProperty);
        }
        return this.castChain();
    }

    public TChain column(TableAvailable table, String property) {
        ColumnMetadata columnMetadata = table.getEntityMetadata().getColumnNotNull(property);
        String alias = table.getEntityMetadata() instanceof MapEntityMetadata ? property : null;
        this.appendColumnMetadata(table, columnMetadata, true, false, false, alias);
        return this.castChain();
    }

    public TChain columnAs(TableAvailable table, String property, String propertyAlias) {
        ColumnMetadata columnMetadata = table.getEntityMetadata().getColumnNotNull(property);
        String alias = propertyAlias == null ? null : table.getEntityMetadata().getColumnNotNull(propertyAlias).getName();
        this.appendColumnMetadata(table, columnMetadata, true, false, false, alias);
        return this.castChain();
    }

    public TChain columnInclude(TableAvailable table, String selfProperty, String aliasProperty, SQLExpression1<AsSelector> includeSelectorExpression) {
        Map propertyColumnIncludeExpressionMap = this.expressionContext.getColumnIncludeMaps().computeIfAbsent(table, k -> new HashMap());
        propertyColumnIncludeExpressionMap.put(selfProperty, new ColumnIncludeExpression(table, selfProperty, aliasProperty, includeSelectorExpression));
        return this.castChain();
    }

    protected void autoColumnInclude(TableAvailable table, EntityMetadata targetEntityMetadata) {
        if (this.expressionContext.hasIncludes()) {
            boolean hasColumnIncludeMaps = this.expressionContext.hasColumnIncludeMaps();
            if (hasColumnIncludeMaps) {
                return;
            }
            for (IncludeNavigateExpression includeNavigateExpression : this.expressionContext.getIncludes().values()) {
                NavigateMetadata navigateMetadata;
                String navigateAutoMappingPropertyName;
                NavigateMetadata navigateOrNull;
                IncludeNavigateParams includeNavigateParams = includeNavigateExpression.getIncludeNavigateParams();
                if (includeNavigateParams.isMappingFlat() || includeNavigateParams.getTable() != table || (navigateOrNull = targetEntityMetadata.getNavigateOrNull(navigateAutoMappingPropertyName = (navigateMetadata = includeNavigateParams.getNavigateMetadata()).getPropertyName())) == null) continue;
                this.columnInclude(table, navigateAutoMappingPropertyName, navigateAutoMappingPropertyName, s -> {
                    TableAvailable entityTable = s.getEntityQueryExpressionBuilder().getTable(0).getEntityTable();
                    if (s.getEntityQueryExpressionBuilder().getProjects().isEmpty()) {
                        s.columnAll(entityTable);
                    }
                    Class<?> navigatePropertyType = navigateOrNull.getNavigatePropertyType();
                    EntityMetadata entityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(navigatePropertyType);
                    this.selectAutoIncludeJoin0((AsSelector)s, s.getEntityQueryExpressionBuilder(), entityMetadata);
                });
            }
        }
    }

    private void selectAutoIncludeJoin0(AsSelector asSelector, EntityQueryExpressionBuilder sqlEntityExpressionBuilder, EntityMetadata resultEntityMetadata) {
        Collection<NavigateJoinMetadata> navigateJoinMetadatas = resultEntityMetadata.getNavigateJoinMetadatas();
        if (EasyCollectionUtil.isNotEmpty(navigateJoinMetadatas)) {
            for (NavigateJoinMetadata navigateJoinMetadata : navigateJoinMetadatas) {
                TableAvailable relationTable = sqlEntityExpressionBuilder.getTable(0).getEntityTable();
                String[] mappingPath = navigateJoinMetadata.getMappingPath();
                if (mappingPath.length < 2) {
                    throw new EasyQueryInvalidOperationException("navigate join mapping length < 2");
                }
                StringBuilder fullName = new StringBuilder();
                for (int i = 0; i < mappingPath.length - 1; ++i) {
                    String navigateEntityProperty = mappingPath[i];
                    fullName.append(navigateEntityProperty).append(".");
                    relationTable = EasyRelationalUtil.getRelationTable(sqlEntityExpressionBuilder, relationTable, navigateEntityProperty, fullName.substring(0, fullName.length() - 1));
                }
                String navigateBasicTypeProperty = mappingPath[mappingPath.length - 1];
                asSelector.columnAs(relationTable, navigateBasicTypeProperty, navigateJoinMetadata.getProperty());
            }
        }
    }

    public TChain columnIgnore(TableAvailable table, String property) {
        this.sqlBuilderSegment.getSQLSegments().removeIf(sqlSegment -> {
            if (sqlSegment instanceof SQLEntitySegment) {
                SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)sqlSegment;
                return Objects.equals(sqlEntitySegment.getTable(), table) && (Objects.equals(sqlEntitySegment.getPropertyName(), property) || sqlEntitySegment.getPropertyName().contains(".") && sqlEntitySegment.getPropertyName().startsWith(property + "."));
            }
            return false;
        });
        return this.castChain();
    }

    public TChain columnIfAbsent(TableAvailable table, String property) {
        for (SQLSegment sqlSegment : this.sqlBuilderSegment.getSQLSegments()) {
            SQLEntitySegment sqlEntitySegment;
            boolean sameTableAndProperty;
            if (!(sqlSegment instanceof SQLEntitySegment) || !(sameTableAndProperty = Objects.equals((sqlEntitySegment = (SQLEntitySegment)sqlSegment).getTable(), table) && (Objects.equals(sqlEntitySegment.getPropertyName(), property) || sqlEntitySegment.getPropertyName().contains(".") && sqlEntitySegment.getPropertyName().startsWith(property + ".")))) continue;
            return this.castChain();
        }
        this.column(table, property);
        return this.castChain();
    }

    public TChain sqlSegmentAs(CloneableSQLSegment sqlColumnSegment) {
        CloneableSQLSegment sqlColumnAsSegment = this.sqlSegmentFactory.createSQLColumnAsSegment(sqlColumnSegment, null, this.runtimeContext);
        this.sqlBuilderSegment.append(sqlColumnAsSegment);
        return this.castChain();
    }

    public TChain columnAll(TableAvailable table) {
        if (table.isAnonymous()) {
            EntityTableExpressionBuilder entityTableExpressionBuilder = this.getTableExpressionBuilderByTable(table);
            if (!(entityTableExpressionBuilder instanceof AnonymousEntityTableExpressionBuilder)) {
                throw new EasyQueryInvalidOperationException("anonymous table is not AnonymousEntityTableExpressionBuilder:" + EasyClassUtil.getSimpleName(table.getEntityClass()));
            }
            this.columnAnonymousAll((AnonymousEntityTableExpressionBuilder)entityTableExpressionBuilder);
        } else {
            boolean queryLargeColumn = this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.QUERY_LARGE_COLUMN);
            EntityMetadata entityMetadata = table.getEntityMetadata();
            Collection<ColumnMetadata> columns = entityMetadata.getColumns();
            for (ColumnMetadata columnMetadata : columns) {
                this.appendColumnMetadata(table, columnMetadata, queryLargeColumn, true, true, null);
            }
            this.autoColumnInclude(table, entityMetadata);
        }
        return this.castChain();
    }

    protected void appendColumnMetadata(TableAvailable table, ColumnMetadata columnMetadata, boolean queryLargeColumn, boolean checkAutoSelect, boolean ignoreValueObject, String alias) {
        if (columnMetadata.isValueObject()) {
            if (!ignoreValueObject) {
                for (ColumnMetadata metadata : columnMetadata.getValueObjectColumnMetadataList()) {
                    this.appendColumnMetadata(table, metadata, queryLargeColumn, checkAutoSelect, false, alias);
                }
            }
            return;
        }
        if (checkAutoSelect && !columnMetadata.isAutoSelect()) {
            return;
        }
        if (this.ignoreColumnIfLargeNotQuery(queryLargeColumn, columnMetadata)) {
            return;
        }
        ColumnSegment columnSegment = this.sqlSegmentFactory.createSelectColumnSegment(table, columnMetadata, this.expressionContext, alias);
        this.sqlBuilderSegment.append(columnSegment);
    }

    private EntityQueryExpressionBuilder getEntityQueryExpressionBuilder(EntityQueryExpressionBuilder entityQueryExpressionBuilder) {
        EntityTableExpressionBuilder entityQueryExpressionBuilderTable;
        if (entityQueryExpressionBuilder instanceof SQLAnonymousUnionEntityQueryExpressionBuilder) {
            List<EntityQueryExpressionBuilder> entityQueryExpressionBuilders = ((SQLAnonymousUnionEntityQueryExpressionBuilder)entityQueryExpressionBuilder).getEntityQueryExpressionBuilders();
            EntityQueryExpressionBuilder first = EasyCollectionUtil.first(entityQueryExpressionBuilders);
            return this.getEntityQueryExpressionBuilder(first);
        }
        if (EasySQLSegmentUtil.isEmpty(entityQueryExpressionBuilder.getProjects()) && EasyCollectionUtil.isSingle(entityQueryExpressionBuilder.getTables()) && (entityQueryExpressionBuilderTable = entityQueryExpressionBuilder.getTable(0)) instanceof AnonymousEntityTableExpressionBuilder) {
            return this.getAnonymousTableQueryExpressionBuilder((AnonymousEntityTableExpressionBuilder)entityQueryExpressionBuilderTable);
        }
        return entityQueryExpressionBuilder;
    }

    protected EntityQueryExpressionBuilder getAnonymousTableQueryExpressionBuilder(AnonymousEntityTableExpressionBuilder table) {
        EntityQueryExpressionBuilder entityQueryExpressionBuilder = table.getEntityQueryExpressionBuilder();
        return this.getEntityQueryExpressionBuilder(entityQueryExpressionBuilder);
    }

    protected TChain columnAnonymousAll(AnonymousEntityTableExpressionBuilder table) {
        EntityQueryExpressionBuilder queryExpressionBuilder = this.getAnonymousTableQueryExpressionBuilder(table);
        if (EasySQLSegmentUtil.isNotEmpty(queryExpressionBuilder.getProjects())) {
            List<SQLSegment> sqlSegments = queryExpressionBuilder.getProjects().getSQLSegments();
            EntityMappingRule entityMappingRule = this.runtimeContext.getEntityMappingRule();
            for (SQLSegment sqlSegment : sqlSegments) {
                if (sqlSegment instanceof SQLEntityAliasSegment) {
                    ColumnSegment columnSegment;
                    SQLEntityAliasSegment sqlEntityAliasSegment = (SQLEntityAliasSegment)sqlSegment;
                    String propertyName = entityMappingRule.getAnonymousPropertyNameFromSQLSegment(sqlEntityAliasSegment, table.getEntityTable());
                    if (propertyName != null) {
                        columnSegment = this.sqlSegmentFactory.createSelectColumnSegment(table.getEntityTable(), propertyName, this.expressionContext, sqlEntityAliasSegment.getAlias());
                        this.sqlBuilderSegment.append(columnSegment);
                        continue;
                    }
                    columnSegment = this.sqlSegmentFactory.createAnonymousColumnSegment(table.getEntityTable(), this.expressionContext, sqlEntityAliasSegment.getAlias());
                    this.sqlBuilderSegment.append(columnSegment);
                    continue;
                }
                throw new EasyQueryException("columnAnonymousAll not found column:" + EasyClassUtil.getInstanceSimpleName(sqlSegment));
            }
        }
        return this.castChain();
    }

    protected boolean ignoreColumnIfLargeNotQuery(boolean queryLargeColumn, ColumnMetadata columnMetadata) {
        if (!queryLargeColumn) {
            return columnMetadata.isLarge();
        }
        return false;
    }

    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    protected EntityTableExpressionBuilder getTableExpressionBuilderByTable(TableAvailable table) {
        EntityTableExpressionBuilder tableBuilder = EasyCollectionUtil.firstOrDefaultOrElseGet(this.entityQueryExpressionBuilder.getTables(), t -> Objects.equals(table, t.getEntityTable()), () -> EasyCollectionUtil.firstOrDefault(this.entityQueryExpressionBuilder.getRelationTables().values(), t -> Objects.equals(table, t.getEntityTable()), null));
        if (tableBuilder == null) {
            throw new EasyQueryInvalidOperationException("not found table in expression context:" + EasyClassUtil.getSimpleName(table.getEntityClass()));
        }
        return tableBuilder;
    }
}

