/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.builder.impl;

import com.easy.query.core.basic.api.select.Query;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.SQLLikeEnum;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.expression.builder.AggregateFilter;
import com.easy.query.core.expression.func.ColumnFunction;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.core.SQLNativeChainExpressionContextImpl;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnValue2Segment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.OrPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.ColumnTrueOrFalsePredicate;
import com.easy.query.core.expression.segment.condition.predicate.FuncColumnValuePredicate;
import com.easy.query.core.expression.segment.condition.predicate.SQLNativePredicateImpl;
import com.easy.query.core.expression.segment.condition.predicate.SQLNativesPredicateImpl;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContext;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContextImpl;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyColumnSegmentUtil;
import java.util.Collection;
import java.util.Objects;

public class AggregateFilterImpl
implements AggregateFilter {
    private final QueryRuntimeContext runtimeContext;
    private final ExpressionContext expressionContext;
    protected final PredicateSegment rootPredicateSegment;
    private final EntityQueryExpressionBuilder entityQueryExpressionBuilder;
    protected PredicateSegment nextPredicateSegment;

    public AggregateFilterImpl(EntityQueryExpressionBuilder entityQueryExpressionBuilder, PredicateSegment predicateSegment) {
        this.entityQueryExpressionBuilder = entityQueryExpressionBuilder;
        this.runtimeContext = entityQueryExpressionBuilder.getRuntimeContext();
        this.expressionContext = entityQueryExpressionBuilder.getExpressionContext();
        this.rootPredicateSegment = predicateSegment;
        this.nextPredicateSegment = new AndPredicateSegment();
    }

    protected void nextAnd() {
        this.rootPredicateSegment.addPredicateSegment(this.nextPredicateSegment);
        this.nextPredicateSegment = new AndPredicateSegment();
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public AggregateFilter func0(TableAvailable table, ColumnFunction columnFunction, String property, SQLPredicateCompare compare, Object val) {
        ColumnMetadata columnMetadata = table.getEntityMetadata().getColumnNotNull(property);
        Column2Segment column2Segment = EasyColumnSegmentUtil.createColumn2Segment(table, columnMetadata, this.expressionContext);
        ColumnValue2Segment compareValue2Segment = EasyColumnSegmentUtil.createColumnCompareValue2Segment(table, columnMetadata, this.expressionContext, val, compare.isLike());
        this.nextPredicateSegment.setPredicate(new FuncColumnValuePredicate(column2Segment, columnFunction, compareValue2Segment, compare));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter func(TableAvailable table, SQLFunction sqlFunction, SQLPredicateCompare compare, Object val) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlNativeExpressionContext.value(val);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + compare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter func(TableAvailable table1, SQLFunction sqlFunction1, SQLPredicateCompare compare, TableAvailable table2, SQLFunction sqlFunction2) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContextLeft = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction1.consume(new SQLNativeChainExpressionContextImpl(table1, sqlNativeExpressionContextLeft));
        String sqlSegmentLeft = sqlFunction1.sqlSegment(table1);
        SQLNativePredicateImpl sqlNativePredicateLeft = new SQLNativePredicateImpl(this.expressionContext, sqlSegmentLeft, sqlNativeExpressionContextLeft);
        SQLNativeExpressionContextImpl sqlNativeExpressionContextRight = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction2.consume(new SQLNativeChainExpressionContextImpl(table2, sqlNativeExpressionContextRight));
        String sqlSegmentRight = sqlFunction2.sqlSegment(table2);
        SQLNativePredicateImpl sqlNativePredicateRight = new SQLNativePredicateImpl(this.expressionContext, sqlSegmentRight, sqlNativeExpressionContextRight);
        this.nextPredicateSegment.setPredicate(new SQLNativesPredicateImpl(this.runtimeContext, sqlNativePredicateLeft, compare, sqlNativePredicateRight));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter func(TableAvailable table, SQLFunction sqlFunction, SQLPredicateCompare compare, TableAvailable table2, String property) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlNativeExpressionContext.expression(table2, property);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + compare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter func(TableAvailable table, SQLFunction sqlFunction, SQLPredicateCompare sqlPredicateAssert) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        String sqlSegment = sqlFunction.sqlSegment(table);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + sqlPredicateAssert.getSQL(), sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public <TProperty> AggregateFilter func(TableAvailable table, SQLFunction sqlFunction, SQLPredicateCompare compare, Query<TProperty> subQuery) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlNativeExpressionContext.expression(subQuery);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + compare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public <TProperty> AggregateFilter func(TableAvailable table, SQLFunction sqlFunction, SQLPredicateCompare compare, Collection<TProperty> collections) {
        if (EasyCollectionUtil.isEmpty(collections)) {
            if (SQLPredicateCompareEnum.IN == compare) {
                this.nextPredicateSegment.setPredicate(new ColumnTrueOrFalsePredicate(false, compare, table));
                this.nextAnd();
                return this;
            }
            if (SQLPredicateCompareEnum.NOT_IN == compare) {
                this.nextPredicateSegment.setPredicate(new ColumnTrueOrFalsePredicate(true, compare, table));
                this.nextAnd();
                return this;
            }
            throw new UnsupportedOperationException();
        }
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        sqlFunction.consume(new SQLNativeChainExpressionContextImpl(table, sqlNativeExpressionContext));
        String sqlSegment = sqlFunction.sqlSegment(table);
        sqlNativeExpressionContext.collection(collections);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment + " " + compare.getSQL() + " {" + sqlFunction.paramMarks() + "}", sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter like(TableAvailable leftTable, String property1, Object val, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.column(leftTable, property1).value(val), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public AggregateFilter like(TableAvailable leftTable, SQLFunction sqlFunction, Object val, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.sqlFunc(leftTable, sqlFunction).value(val), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public AggregateFilter like(TableAvailable leftTable, String property1, TableAvailable rightTable, String property2, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.column(leftTable, property1).column(rightTable, property2), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public AggregateFilter like(TableAvailable leftTable, String property1, TableAvailable rightTable, SQLFunction sqlFunction, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.column(leftTable, property1).sqlFunc(rightTable, sqlFunction), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public AggregateFilter like(TableAvailable leftTable, SQLFunction sqlFunction, TableAvailable rightTable, String property2, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.sqlFunc(leftTable, sqlFunction).column(rightTable, property2), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    @Override
    public AggregateFilter like(TableAvailable leftTable, SQLFunction sqlFunction1, TableAvailable rightTable, SQLFunction sqlFunction2, boolean like, SQLLikeEnum sqlLike) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLFunction likeSQLFunction = this.runtimeContext.fx().like(x -> x.sqlFunc(leftTable, sqlFunction1).sqlFunc(rightTable, sqlFunction2), like, sqlLike);
        return this.getLikePredicateFilter(leftTable, sqlNativeExpressionContext, likeSQLFunction);
    }

    private AggregateFilter getLikePredicateFilter(TableAvailable leftTable, SQLNativeExpressionContextImpl sqlNativeExpressionContext, SQLFunction likeSQLFunction) {
        likeSQLFunction.consume(new SQLNativeChainExpressionContextImpl(leftTable, sqlNativeExpressionContext));
        String sqlSegment = likeSQLFunction.sqlSegment(leftTable);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment, sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter sqlNativeSegment(String sqlSegment, SQLExpression1<SQLNativeExpressionContext> contextConsume) {
        Objects.requireNonNull(contextConsume, "sql native context consume cannot be null");
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.entityQueryExpressionBuilder.getExpressionContext(), this.runtimeContext);
        contextConsume.apply(sqlNativeExpressionContext);
        this.nextPredicateSegment.setPredicate(new SQLNativePredicateImpl(this.expressionContext, sqlSegment, sqlNativeExpressionContext));
        this.nextAnd();
        return this;
    }

    @Override
    public AggregateFilter and() {
        this.nextPredicateSegment = new AndPredicateSegment();
        return this;
    }

    @Override
    public AggregateFilter and(SQLExpression1<AggregateFilter> aggregateFilterSQLExpression) {
        this.rootPredicateSegment.addPredicateSegment(this.nextPredicateSegment);
        AggregateFilterImpl aggregateFilter = new AggregateFilterImpl(this.entityQueryExpressionBuilder, this.nextPredicateSegment);
        aggregateFilterSQLExpression.apply(aggregateFilter);
        return this;
    }

    @Override
    public AggregateFilter or() {
        this.nextPredicateSegment = new OrPredicateSegment();
        return this;
    }

    @Override
    public AggregateFilter or(SQLExpression1<AggregateFilter> aggregateFilterSQLExpression) {
        this.nextPredicateSegment = new OrPredicateSegment();
        this.rootPredicateSegment.addPredicateSegment(this.nextPredicateSegment);
        AggregateFilterImpl aggregateFilter = new AggregateFilterImpl(this.entityQueryExpressionBuilder, this.nextPredicateSegment);
        aggregateFilterSQLExpression.apply(aggregateFilter);
        return this;
    }
}

