/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.builder.impl;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.builder.OrderSelector;
import com.easy.query.core.expression.func.ColumnFunction;
import com.easy.query.core.expression.func.ColumnPropertyFunction;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.OrderFuncColumnSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContext;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContextImpl;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.SQLFunctionTranslateImpl;
import java.util.Objects;

public class OrderSelectorImpl
implements OrderSelector {
    private final QueryRuntimeContext runtimeContext;
    private final ExpressionContext expressionContext;
    private final SQLSegmentFactory sqlSegmentFactory;
    private final SQLBuilderSegment order;
    protected boolean asc;

    public OrderSelectorImpl(QueryRuntimeContext runtimeContext, ExpressionContext expressionContext, SQLBuilderSegment order) {
        this.runtimeContext = runtimeContext;
        this.expressionContext = expressionContext;
        this.sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
        this.order = order;
        this.asc = true;
    }

    @Override
    public OrderSelector column(TableAvailable table, String property) {
        OrderBySegment orderByColumnSegment = this.sqlSegmentFactory.createOrderByColumnSegment(table, property, this.expressionContext, this.asc);
        this.order.append(orderByColumnSegment);
        return this;
    }

    @Override
    public OrderSelector func(TableAvailable table, SQLFunction sqlFunction, boolean appendASC) {
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        SQLSegment sqlSegment = new SQLFunctionTranslateImpl(sqlFunction).toSQLSegment(this.expressionContext, table, this.runtimeContext, null);
        String appendAsc = appendASC ? (this.asc ? " ASC" : " DESC") : "";
        OrderBySegment orderByColumnSegment = this.sqlSegmentFactory.createOrderBySQLNativeSegment2(this.expressionContext, sqlSegment, s -> s + appendAsc, sqlNativeExpressionContext, this.asc);
        this.order.append(orderByColumnSegment);
        return this;
    }

    @Override
    public OrderSelector sqlNativeSegment(String columnConst, SQLExpression1<SQLNativeExpressionContext> contextConsume) {
        Objects.requireNonNull(contextConsume, "sql native context consume cannot be null");
        SQLNativeExpressionContextImpl sqlConstExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.runtimeContext);
        contextConsume.apply(sqlConstExpressionContext);
        OrderBySegment orderByColumnSegment = this.sqlSegmentFactory.createOrderBySQLNativeSegment(this.expressionContext, columnConst, sqlConstExpressionContext, this.asc);
        this.order.append(orderByColumnSegment);
        return this;
    }

    @Override
    public OrderSelector columnFunc(TableAvailable table, ColumnPropertyFunction columnPropertyFunction) {
        String propertyName = columnPropertyFunction.getPropertyName();
        ColumnFunction columnFunction = columnPropertyFunction.getColumnFunction();
        OrderFuncColumnSegment orderFuncColumnSegment = this.sqlSegmentFactory.createOrderFuncColumnSegment(table, propertyName, this.expressionContext, columnFunction, this.asc);
        this.order.append(orderFuncColumnSegment);
        return this;
    }

    @Override
    public void setAsc(boolean asc) {
        this.asc = asc;
    }

    @Override
    public boolean isAsc() {
        return this.asc;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }
}

