/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.func;

import com.easy.query.core.expression.func.AggregationType;
import com.easy.query.core.expression.func.ColumnFunction;

public enum DefaultColumnFunction implements ColumnFunction
{
    SUM("SUM(%s)", AggregationType.SUM),
    COUNT("COUNT(%s)", AggregationType.COUNT),
    MAX("MAX(%s)", AggregationType.MAX),
    MIN("MIN(%s)", AggregationType.MIN),
    AVG("AVG(%s)", AggregationType.AVG),
    COUNT_DISTINCT("COUNT(DISTINCT %s)", AggregationType.COUNT_DISTINCT),
    SUM_DISTINCT("SUM(DISTINCT %s)", AggregationType.SUM_DISTINCT),
    AVG_DISTINCT("AVG(DISTINCT %s)", AggregationType.AVG_DISTINCT),
    LEN("LENGTH(%s)", AggregationType.LENGTH);

    private final String aggregate;
    private final AggregationType aggregationType;

    private DefaultColumnFunction(String aggregate, AggregationType aggregationType) {
        this.aggregate = aggregate;
        this.aggregationType = aggregationType;
    }

    @Override
    public String getFuncColumn(String column) {
        return String.format(this.aggregate, column);
    }

    @Override
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }
}

