/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.include;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.include.IncludeProcessor;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.expression.sql.include.RelationValue;
import com.easy.query.core.expression.sql.include.multi.RelationValueColumnMetadata;
import com.easy.query.core.expression.sql.include.multi.RelationValueFactory;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractIncludeProcessor
implements IncludeProcessor {
    protected final Collection<RelationExtraEntity> entities;
    protected final EntityMetadata selfEntityMetadata;
    protected final IncludeParserResult includeParserResult;
    protected final QueryRuntimeContext runtimeContext;
    protected final RelationValueFactory relationValueFactory;
    protected final EntityMetadata targetEntityMetadata;
    protected final String[] targetColumnMetadataPropertyNames;
    protected Class<?> collectionType;

    public AbstractIncludeProcessor(IncludeParserResult includeParserResult, QueryRuntimeContext runtimeContext) {
        this.entities = includeParserResult.getRelationExtraEntities();
        this.includeParserResult = includeParserResult;
        this.selfEntityMetadata = includeParserResult.getEntityMetadata();
        this.runtimeContext = runtimeContext;
        this.relationValueFactory = runtimeContext.getRelationValueFactory();
        this.targetEntityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(includeParserResult.getNavigatePropertyType());
        this.targetColumnMetadataPropertyNames = this.getTargetRelationColumn();
    }

    private String[] getTargetRelationColumn() {
        String[] stringArray;
        if (EasyArrayUtil.isEmpty(this.includeParserResult.getTargetProperties())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getTargetSingleKeyProperty();
        } else {
            stringArray = this.includeParserResult.getTargetProperties();
        }
        return stringArray;
    }

    private String getTargetSingleKeyProperty() {
        Collection<String> keyProperties = this.targetEntityMetadata.getKeyProperties();
        if (EasyCollectionUtil.isNotSingle(keyProperties)) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName(this.targetEntityMetadata.getEntityClass()) + "multi key not support include");
        }
        return EasyCollectionUtil.first(keyProperties);
    }

    protected <TNavigateEntity> Map<RelationValue, Collection<TNavigateEntity>> getTargetToManyMap(List<RelationExtraEntity> includes) {
        Class<? extends Collection> collectionType = EasyClassUtil.getCollectionImplType(this.includeParserResult.getNavigateOriginalPropertyType());
        HashMap<RelationValue, Collection<TNavigateEntity>> resultMap = new HashMap<RelationValue, Collection<TNavigateEntity>>();
        for (RelationExtraEntity target : includes) {
            RelationValue targetRelationId = target.getRelationExtraColumns(this.targetColumnMetadataPropertyNames);
            Collection objects = resultMap.computeIfAbsent(targetRelationId, k -> (Collection)EasyClassUtil.newInstance(collectionType));
            objects.add(target.getEntity());
        }
        return resultMap;
    }

    protected Class<?> getCollectionType() {
        if (this.collectionType == null) {
            this.collectionType = EasyClassUtil.getCollectionImplType(this.includeParserResult.getNavigateOriginalPropertyType());
        }
        return this.collectionType;
    }

    protected <TNavigateEntity> Collection<TNavigateEntity> createManyCollection() {
        Class<?> collectionType = this.getCollectionType();
        return (Collection)EasyObjectUtil.typeCastNullable(EasyClassUtil.newInstance(collectionType));
    }

    protected <TNavigateEntity> Map<RelationValue, Collection<TNavigateEntity>> getTargetToManyMap(List<RelationExtraEntity> includes, List<Map<String, Object>> mappingRows) {
        HashMap<RelationValue, Collection<TNavigateEntity>> resultMap = new HashMap<RelationValue, Collection<TNavigateEntity>>();
        EntityMetadata entityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(this.includeParserResult.getMappingClass());
        RelationValueColumnMetadata selfRelationColumn = this.relationValueFactory.create(entityMetadata, this.includeParserResult.getSelfMappingProperties());
        RelationValueColumnMetadata targetRelationColumn = this.relationValueFactory.create(entityMetadata, this.includeParserResult.getTargetMappingProperties());
        Map<RelationValue, Collection<TNavigateEntity>> targetToManyMap = this.getTargetToManyMap(includes);
        for (Map<String, Object> mappingRow : mappingRows) {
            RelationValue selfRelationId = selfRelationColumn.getRelationValue(mappingRow);
            RelationValue targetRelationId = targetRelationColumn.getRelationValue(mappingRow);
            Collection targetEntities = resultMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
            Collection<TNavigateEntity> targets = targetToManyMap.get(targetRelationId);
            if (!EasyCollectionUtil.isNotEmpty(targets)) continue;
            targetEntities.addAll(targets);
        }
        return resultMap;
    }

    @Override
    public void process() {
        switch (this.includeParserResult.getRelationType()) {
            case OneToOne: {
                this.OneToOneProcess(this.includeParserResult.getIncludeResult());
                return;
            }
            case OneToMany: {
                this.OneToManyProcess(this.includeParserResult.getIncludeResult());
                return;
            }
            case ManyToOne: {
                this.ManyToOneProcess(this.includeParserResult.getIncludeResult());
                return;
            }
            case ManyToMany: {
                this.ManyToManyProcess(this.includeParserResult.getIncludeResult(), this.includeParserResult.getMappingRows());
                return;
            }
        }
        throw new UnsupportedOperationException("not support include relation type:" + (Object)((Object)this.includeParserResult.getRelationType()));
    }

    protected abstract void OneToOneProcess(List<RelationExtraEntity> var1);

    protected abstract void ManyToOneProcess(List<RelationExtraEntity> var1);

    protected abstract void OneToManyProcess(List<RelationExtraEntity> var1);

    protected abstract void ManyToManyProcess(List<RelationExtraEntity> var1, List<Map<String, Object>> var2);

    protected <T> void setEntityValue(T entity, Object value) {
        this.includeParserResult.getSetter().call(entity, value);
    }

    public String[] getSelfRelationColumn() {
        return this.includeParserResult.getSelfProperties();
    }
}

