/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.include;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.include.AbstractIncludeProcessor;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.expression.sql.include.RelationValue;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EasyIncludeProcess
extends AbstractIncludeProcessor {
    public EasyIncludeProcess(IncludeParserResult includeParserResult, QueryRuntimeContext runtimeContext) {
        super(includeParserResult, runtimeContext);
    }

    @Override
    protected void OneToOneProcess(List<RelationExtraEntity> includes) {
        String[] selfRelationColumn = this.getSelfRelationColumn();
        Map<RelationValue, Object> entityMap = EasyCollectionUtil.collectionToMap(this.entities, x -> x.getRelationExtraColumns(selfRelationColumn), o -> o.getEntity(), (key, old) -> {
            if (old != null) {
                throw new EasyQueryInvalidOperationException("The relationship value \u2018" + key + "\u2019 appears to have duplicates: [" + EasyClassUtil.getInstanceSimpleName(old) + "]. Please confirm whether the data represents a One-To-One or Many-To-One relationship.");
            }
        });
        HashSet<RelationValue> checkToOne = new HashSet<RelationValue>();
        for (RelationExtraEntity includeEntity : includes) {
            RelationValue subRelationKey = includeEntity.getRelationExtraColumns(this.targetColumnMetadataPropertyNames);
            if (!checkToOne.add(subRelationKey)) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName(this.selfEntityMetadata.getEntityClass()) + "] target entity:[" + EasyClassUtil.getSimpleName(this.targetEntityMetadata.getEntityClass()) + "] Please confirm whether the data represents a One-To-One or One-To-Many relationship.");
            }
            Object entity = entityMap.get(subRelationKey);
            if (entity == null) continue;
            this.setEntityValue(entity, includeEntity.getEntity());
        }
    }

    @Override
    protected void ManyToOneProcess(List<RelationExtraEntity> includes) {
        Map<RelationValue, Object> includeMap = EasyCollectionUtil.collectionToMap(includes, x -> x.getRelationExtraColumns(this.targetColumnMetadataPropertyNames), o -> o.getEntity(), (key, old) -> {
            if (old != null) {
                throw new EasyQueryInvalidOperationException("The relationship value \u2018" + key + "\u2019 appears to have duplicates: [" + EasyClassUtil.getInstanceSimpleName(old) + "]. Please confirm whether the data represents a Many-To-One or Many-To-Many relationship.");
            }
        });
        String[] selfRelationColumn = this.getSelfRelationColumn();
        for (RelationExtraEntity entity : this.entities) {
            RelationValue relationId = entity.getRelationExtraColumns(selfRelationColumn);
            Object entityInclude = includeMap.get(relationId);
            if (entityInclude == null) continue;
            this.setEntityValue(entity.getEntity(), entityInclude);
        }
    }

    @Override
    protected void OneToManyProcess(List<RelationExtraEntity> includes) {
        String[] selfRelationColumn = this.getSelfRelationColumn();
        Map targetToManyMap = this.getTargetToManyMap(includes);
        for (RelationExtraEntity entity : this.entities) {
            RelationValue selfRelationId = entity.getRelationExtraColumns(selfRelationColumn);
            Collection targetEntities = targetToManyMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
            this.setEntityValue(entity.getEntity(), targetEntities);
        }
    }

    @Override
    protected void ManyToManyProcess(List<RelationExtraEntity> includes, List<Map<String, Object>> mappingRows) {
        if (this.includeParserResult.getMappingClass() == null) {
            String[] selfRelationColumn = this.getSelfRelationColumn();
            Map targetToManyMap = this.getTargetToManyMap(includes);
            for (RelationExtraEntity entity : this.entities) {
                RelationValue selfRelationId = entity.getRelationExtraColumns(selfRelationColumn);
                Collection targetEntities = targetToManyMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
                this.setEntityValue(entity.getEntity(), targetEntities);
            }
        } else {
            Map targetToManyMap = this.getTargetToManyMap(includes, mappingRows);
            String[] selfRelationColumn = this.getSelfRelationColumn();
            for (RelationExtraEntity entity : this.entities) {
                RelationValue selfRelationId = entity.getRelationExtraColumns(selfRelationColumn);
                Collection targetEntities = targetToManyMap.computeIfAbsent(selfRelationId, k -> this.createManyCollection());
                this.setEntityValue(entity.getEntity(), targetEntities);
            }
        }
    }
}

