/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.parser.core.base;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.base.MultiCollection;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiCollectionImpl
implements MultiCollection {
    private final List<List<Object>> relationIds;
    private final List<Object> singleCollection;

    public MultiCollectionImpl(List<List<Object>> relationIds) {
        this.relationIds = relationIds;
        this.singleCollection = new ArrayList<Object>();
    }

    @Override
    public Collection<Object> singleCollection() {
        return this.getSingleFromNestCollection();
    }

    private Collection<Object> getSingleFromNestCollection() {
        this.singleCollection.clear();
        for (List<Object> objects : this.relationIds) {
            if (objects == null) {
                throw new EasyQueryInvalidOperationException("nest collection has null element");
            }
            if (objects.size() != 1) {
                throw new EasyQueryInvalidOperationException("nest collection element.size() != 1");
            }
            this.singleCollection.add(EasyCollectionUtil.first(objects));
        }
        return this.singleCollection;
    }

    @Override
    public Collection<List<Object>> multiCollection() {
        return this.relationIds;
    }
}

