/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.parser.core.base.impl;

import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.expression.lambda.SQLFuncExpression;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.NavigateInclude;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.IncludeNavigateParams;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyOptionUtil;

public class NavigateIncludeImpl<TEntity>
implements NavigateInclude<TEntity> {
    private final TableAvailable entityTable;
    private final QueryRuntimeContext runtimeContext;
    private final IncludeNavigateParams includeNavigateParams;
    private final ExpressionContext expressionContext;

    public NavigateIncludeImpl(TableAvailable table, QueryRuntimeContext runtimeContext, IncludeNavigateParams includeNavigateParams, ExpressionContext expressionContext) {
        this.entityTable = table;
        this.runtimeContext = runtimeContext;
        this.includeNavigateParams = includeNavigateParams;
        this.expressionContext = expressionContext;
    }

    private NavigateMetadata withBefore(String property, Integer groupSize) {
        if (groupSize != null && groupSize < 1) {
            throw new IllegalArgumentException("include group size < 1");
        }
        NavigateMetadata navigateMetadata = this.entityTable.getEntityMetadata().getNavigateNotNull(property);
        this.includeNavigateParams.setNavigateMetadata(navigateMetadata);
        this.includeNavigateParams.setTable(this.entityTable);
        if (groupSize == null) {
            this.includeNavigateParams.setRelationGroupSize(this.runtimeContext.getQueryConfiguration().getEasyQueryOption().getRelationGroupSize());
        } else {
            this.includeNavigateParams.setRelationGroupSize(groupSize);
        }
        RelationTypeEnum relationType = navigateMetadata.getRelationType();
        if (RelationTypeEnum.ManyToMany == relationType && navigateMetadata.getMappingClass() != null) {
            SQLFuncExpression<ClientQueryable<?>> mappingQueryableFunction = () -> {
                ClientQueryable<?> mappingQuery = this.runtimeContext.getSQLClientApiFactory().createQueryable(navigateMetadata.getMappingClass(), this.runtimeContext);
                Boolean printSQL = EasyOptionUtil.isPrintNavSQL(this.expressionContext);
                return ((ClientQueryable)mappingQuery.configure(s -> {
                    s.setPrintSQL(printSQL);
                    s.setPrintNavSQL(printSQL);
                })).where(t -> {
                    t.relationIn(navigateMetadata.getSelfMappingProperties(), this.includeNavigateParams.getRelationIds());
                    navigateMetadata.predicateMappingClassFilterApply((WherePredicate<?>)t);
                }).select(o -> {
                    for (String selfMappingProperty : navigateMetadata.getSelfMappingProperties()) {
                        o.column(selfMappingProperty);
                    }
                    for (String targetMappingProperty : navigateMetadata.getTargetMappingProperties()) {
                        o.column(targetMappingProperty);
                    }
                });
            };
            this.includeNavigateParams.setMappingQueryableFunction(mappingQueryableFunction);
        }
        return navigateMetadata;
    }

    @Override
    public IncludeNavigateParams getIncludeNavigateParams() {
        return this.includeNavigateParams;
    }

    @Override
    public <TREntity> ClientQueryable<TREntity> with(String property, Integer groupSize) {
        NavigateMetadata navigateMetadata = this.withBefore(property, groupSize);
        Class<?> navigatePropertyType = navigateMetadata.getNavigatePropertyType();
        boolean tracking = this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.USE_TRACKING);
        ClientQueryable queryable = this.runtimeContext.getSQLClientApiFactory().createQueryable((Class)EasyObjectUtil.typeCastNullable(navigatePropertyType), this.runtimeContext);
        Boolean printNavSQL = EasyOptionUtil.isPrintNavSQL(this.expressionContext);
        if (tracking) {
            queryable.getSQLEntityExpressionBuilder().getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.USE_TRACKING);
        } else {
            queryable.getSQLEntityExpressionBuilder().getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.USE_TRACKING);
        }
        if (!this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.USE_INTERCEPTOR)) {
            queryable.getSQLEntityExpressionBuilder().getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.USE_INTERCEPTOR);
        }
        this.expressionContext.getExpressionContextInterceptor().copyTo(queryable.getSQLEntityExpressionBuilder().getExpressionContext().getExpressionContextInterceptor());
        return (ClientQueryable)queryable.configure(s -> {
            s.setPrintSQL(printNavSQL);
            s.setPrintNavSQL(printNavSQL);
        });
    }
}

