/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.parser.core.base.impl;

import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.builder.Filter;
import com.easy.query.core.expression.builder.core.SQLNative;
import com.easy.query.core.expression.func.ColumnPropertyFunction;
import com.easy.query.core.expression.lambda.SQLActionExpression;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.lambda.SQLExpression2;
import com.easy.query.core.expression.parser.core.EntitySQLTableOwner;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.expression.parser.core.base.core.FilterContext;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.Collections;
import java.util.List;

public class WherePredicateImpl<T1>
implements WherePredicate<T1> {
    private final FilterContext filterContext;
    private final TableAvailable table;

    public WherePredicateImpl(TableAvailable table, FilterContext filterContext) {
        this.filterContext = filterContext;
        this.table = table;
    }

    @Override
    public Filter getFilter() {
        return this.filterContext.getFilter();
    }

    @Override
    public WherePredicate<T1> castChain() {
        return this;
    }

    @Override
    public WherePredicate<T1> columnFunc(boolean condition, ColumnPropertyFunction columnPropertyFunction, SQLPredicateCompare sqlPredicateCompare, Object val) {
        if (condition) {
            this.getFilter().columnFunc(this.table, columnPropertyFunction, sqlPredicateCompare, val);
        }
        return this;
    }

    @Override
    public <T2> WherePredicate<T1> compareSelf(boolean condition, EntitySQLTableOwner<T2> sub, String property1, String property2, SQLPredicateCompare sqlPredicateCompare) {
        if (condition) {
            TableAvailable rightTable = sub.getTable();
            this.getFilter().valueColumnFilter(this.table, property1, rightTable, property2, sqlPredicateCompare);
        }
        return this.castChain();
    }

    @Override
    public <T2> WherePredicate<T1> multiEq(boolean condition, EntitySQLTableOwner<T2> sub, String[] properties1, String[] properties2) {
        if (condition) {
            if (EasyArrayUtil.isEmpty(properties1)) {
                throw new EasyQueryInvalidOperationException("properties1 is empty");
            }
            if (EasyArrayUtil.isEmpty(properties2)) {
                throw new EasyQueryInvalidOperationException("properties2 is empty");
            }
            if (properties1.length != properties2.length) {
                throw new EasyQueryInvalidOperationException("properties1.length != properties2.length");
            }
            if (properties1.length == 1) {
                this.eq(sub, properties1[0], properties2[0]);
            } else {
                this.and(() -> {
                    for (int i = 0; i < properties1.length; ++i) {
                        this.eq(sub, properties1[i], properties2[i]);
                    }
                });
            }
        }
        return this.castChain();
    }

    @Override
    public <T2> WherePredicate<T1> ne(boolean condition, EntitySQLTableOwner<T2> sub, String property1, String property2) {
        return this.compareSelf(condition, sub, property1, property2, SQLPredicateCompareEnum.NE);
    }

    @Override
    public <T2> WherePredicate<T1> gt(boolean condition, EntitySQLTableOwner<T2> sub, String property1, String property2) {
        return this.compareSelf(condition, sub, property1, property2, SQLPredicateCompareEnum.GT);
    }

    @Override
    public <T2> WherePredicate<T1> ge(boolean condition, EntitySQLTableOwner<T2> sub, String property1, String property2) {
        return this.compareSelf(condition, sub, property1, property2, SQLPredicateCompareEnum.GE);
    }

    @Override
    public <T2> WherePredicate<T1> le(boolean condition, EntitySQLTableOwner<T2> sub, String property1, String property2) {
        return this.compareSelf(condition, sub, property1, property2, SQLPredicateCompareEnum.LE);
    }

    @Override
    public <T2> WherePredicate<T1> lt(boolean condition, EntitySQLTableOwner<T2> sub, String property1, String property2) {
        return this.compareSelf(condition, sub, property1, property2, SQLPredicateCompareEnum.LT);
    }

    @Override
    public <T2> WherePredicate<T2> then(WherePredicate<T2> sub) {
        return sub;
    }

    @Override
    public WherePredicate<T1> and(boolean condition) {
        if (condition) {
            this.getFilter().and();
        }
        return this;
    }

    @Override
    public WherePredicate<T1> and(boolean condition, SQLExpression1<WherePredicate<T1>> sqlWherePredicateSQLExpression) {
        if (condition) {
            this.getFilter().and((Filter f) -> {
                Filter filter = this.filterContext.getFilter();
                this.filterContext.setFilter((Filter)f);
                sqlWherePredicateSQLExpression.apply(new WherePredicateImpl<T1>(this.table, this.filterContext));
                this.filterContext.setFilter(filter);
            });
        }
        return this;
    }

    @Override
    public WherePredicate<T1> and(boolean condition, SQLActionExpression sqlWherePredicateSQLExpression) {
        if (condition) {
            this.getFilter().and((Filter f) -> {
                Filter filter = this.filterContext.getFilter();
                this.filterContext.setFilter((Filter)f);
                sqlWherePredicateSQLExpression.apply();
                this.filterContext.setFilter(filter);
            });
        }
        return this;
    }

    @Override
    public <T2> WherePredicate<T1> and(boolean condition, WherePredicate<T2> t2WherePredicate, SQLExpression2<WherePredicate<T1>, WherePredicate<T2>> sqlWherePredicateSQLExpression) {
        if (condition) {
            this.getFilter().and((Filter f) -> {
                Filter filter = this.filterContext.getFilter();
                this.filterContext.setFilter((Filter)f);
                sqlWherePredicateSQLExpression.apply(new WherePredicateImpl<T1>(this.table, this.filterContext), new WherePredicateImpl<T1>(t2WherePredicate.getTable(), this.filterContext));
                this.filterContext.setFilter(filter);
            });
        }
        return this;
    }

    @Override
    public WherePredicate<T1> or(boolean condition) {
        if (condition) {
            this.getFilter().or();
        }
        return this;
    }

    @Override
    public WherePredicate<T1> or(boolean condition, SQLExpression1<WherePredicate<T1>> sqlWherePredicateSQLExpression) {
        if (condition) {
            this.getFilter().or((Filter f) -> {
                Filter filter = this.filterContext.getFilter();
                this.filterContext.setFilter((Filter)f);
                sqlWherePredicateSQLExpression.apply(new WherePredicateImpl<T1>(this.table, this.filterContext));
                this.filterContext.setFilter(filter);
            });
        }
        return this;
    }

    @Override
    public WherePredicate<T1> or(boolean condition, SQLActionExpression sqlWherePredicateSQLExpression) {
        if (condition) {
            this.getFilter().or((Filter f) -> {
                Filter filter = this.filterContext.getFilter();
                this.filterContext.setFilter((Filter)f);
                sqlWherePredicateSQLExpression.apply();
                this.filterContext.setFilter(filter);
            });
        }
        return this;
    }

    @Override
    public <T2> WherePredicate<T1> or(boolean condition, WherePredicate<T2> t2WherePredicate, SQLExpression2<WherePredicate<T1>, WherePredicate<T2>> sqlWherePredicateSQLExpression) {
        if (condition) {
            this.getFilter().or((Filter f) -> {
                Filter filter = this.filterContext.getFilter();
                this.filterContext.setFilter((Filter)f);
                sqlWherePredicateSQLExpression.apply(new WherePredicateImpl<T1>(this.table, this.filterContext), new WherePredicateImpl<T1>(t2WherePredicate.getTable(), this.filterContext));
                this.filterContext.setFilter(filter);
            });
        }
        return this;
    }

    @Override
    public <T2> WherePredicate<T2> withOther(WherePredicate<T2> wherePredicate) {
        return new WherePredicateImpl<T1>(wherePredicate.getTable(), this.filterContext);
    }

    @Override
    public <T> SQLNative<T> getSQLNative() {
        return (SQLNative)EasyObjectUtil.typeCastNullable(this.getFilter());
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public WherePredicate<T1> multiEq(boolean condition, String[] properties, List<Object> vals) {
        if (condition) {
            if (EasyArrayUtil.isEmpty(properties)) {
                throw new EasyQueryInvalidOperationException("properties is empty");
            }
            if (EasyCollectionUtil.isEmpty(vals)) {
                throw new EasyQueryInvalidOperationException("vals is empty");
            }
            if (properties.length != vals.size()) {
                throw new EasyQueryInvalidOperationException("properties.length != vals.size()");
            }
            if (properties.length == 1) {
                this.eq(properties[0], vals.get(0));
            } else {
                this.getFilter().relationEq(this.getTable(), properties, Collections.singletonList(vals));
            }
        }
        return this;
    }
}

