/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.builder;

import com.easy.query.core.expression.lambda.BreakConsumer;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.SubQueryColumnSegment;
import com.easy.query.core.expression.segment.builder.EasySegmentIndexContext;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.index.EntitySegmentComparer;
import com.easy.query.core.expression.segment.index.SegmentIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractSQLBuilderSegment
implements SQLBuilderSegment {
    private final List<SQLSegment> sqlSegments = new ArrayList<SQLSegment>();

    @Override
    public void append(SQLSegment sqlSegment) {
        this.sqlSegments.add(sqlSegment);
    }

    @Override
    public List<SQLSegment> getSQLSegments() {
        return this.sqlSegments;
    }

    @Override
    public boolean isEmpty() {
        return this.sqlSegments.isEmpty();
    }

    @Override
    public void copyTo(SQLBuilderSegment predicateSegment) {
        for (SQLSegment sqlSegment : this.sqlSegments) {
            if (sqlSegment instanceof SubQueryColumnSegment) {
                SubQueryColumnSegment subQueryColumnSegment = (SubQueryColumnSegment)sqlSegment;
                predicateSegment.getSQLSegments().add(subQueryColumnSegment.cloneSQLColumnSegment());
                continue;
            }
            predicateSegment.getSQLSegments().add(sqlSegment);
        }
    }

    @Override
    public boolean containsOnce(Class<?> entityClass, String propertyName) {
        for (SQLSegment sqlSegment : this.sqlSegments) {
            SQLEntitySegment sqlEntitySegment;
            if (!(sqlSegment instanceof SQLEntitySegment) || !Objects.equals((sqlEntitySegment = (SQLEntitySegment)sqlSegment).getTable().getEntityClass(), entityClass) || !Objects.equals(sqlEntitySegment.getPropertyName(), propertyName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Consumer<EntitySegmentComparer> visitorConsumer) {
        for (SQLSegment sqlSegment : this.sqlSegments) {
            if (!(sqlSegment instanceof SQLEntitySegment)) continue;
            SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)sqlSegment;
            EntitySegmentComparer entitySegmentComparerKey = new EntitySegmentComparer(sqlEntitySegment.getTable().getEntityClass(), sqlEntitySegment.getPropertyName());
            visitorConsumer.accept(entitySegmentComparerKey);
        }
    }

    @Override
    public SegmentIndex buildSegmentIndex() {
        EasySegmentIndexContext easySegmentIndexContext = new EasySegmentIndexContext();
        for (SQLSegment sqlSegment : this.sqlSegments) {
            if (!(sqlSegment instanceof SQLEntitySegment)) continue;
            easySegmentIndexContext.add((SQLEntitySegment)sqlSegment);
        }
        return easySegmentIndexContext;
    }

    @Override
    public boolean forEach(BreakConsumer<SQLSegment> consumer) {
        for (SQLSegment sqlSegment : this.sqlSegments) {
            if (!consumer.accept(sqlSegment)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.sqlSegments.clear();
    }
}

