/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.lambda.BreakConsumer;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.EasyPredicateIndexContext;
import com.easy.query.core.expression.segment.condition.OrPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.ShardingPredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.SubQueryPredicate;
import com.easy.query.core.expression.segment.index.SegmentIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractPredicateSegment
implements PredicateSegment,
ShardingPredicateSegment {
    protected List<PredicateSegment> children;
    protected Predicate predicate;
    protected final boolean root;

    @Override
    public List<PredicateSegment> getChildren() {
        return this.children;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public boolean isEmpty() {
        return this.predicate == null && this.children == null;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public AbstractPredicateSegment() {
        this(false);
    }

    public AbstractPredicateSegment(boolean root) {
        this(null, root);
    }

    public AbstractPredicateSegment(Predicate predicate) {
        this(predicate, false);
    }

    public AbstractPredicateSegment(Predicate predicate, boolean root) {
        this.setPredicate(predicate);
        this.root = root;
    }

    @Override
    public boolean isPredicate() {
        return this.predicate != null && this.children == null;
    }

    @Override
    public void setPredicate(Predicate predicate) {
        if (!this.isEmpty()) {
            throw new EasyQueryException("sql segment cant set predicate.");
        }
        this.predicate = predicate;
    }

    @Override
    public void addPredicateSegment(PredicateSegment predicateSegment) {
        if (this.isPredicate()) {
            throw new EasyQueryException("sql segment is predicate can't add predicate segment");
        }
        if (this.children == null) {
            this.children = new ArrayList<PredicateSegment>();
        }
        this.children.add(predicateSegment);
    }

    @Override
    public boolean containsOnce(Class<?> entityClass, String propertyName) {
        if (this.isPredicate()) {
            return Objects.equals(this.predicate.getTable().getEntityClass(), entityClass) && Objects.equals(this.predicate.getPropertyName(), propertyName);
        }
        if (this.children != null) {
            for (PredicateSegment child : this.children) {
                if (!child.containsOnce(entityClass, propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean forEach(BreakConsumer<Predicate> consumer) {
        if (this.isPredicate()) {
            return consumer.accept(this.predicate);
        }
        if (this.children != null) {
            for (PredicateSegment child : this.children) {
                if (!child.forEach(consumer)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SegmentIndex buildPredicateIndex() {
        EasyPredicateIndexContext easyPredicateContext = new EasyPredicateIndexContext();
        this.buildPredicateIndex(easyPredicateContext);
        return easyPredicateContext;
    }

    protected void buildPredicateIndex(EasyPredicateIndexContext easyPredicateContext) {
        if (this.isPredicate()) {
            easyPredicateContext.add(this.predicate);
        } else if (this.children != null) {
            for (PredicateSegment child : this.children) {
                ((AbstractPredicateSegment)child).buildPredicateIndex(easyPredicateContext);
            }
        }
    }

    @Override
    public void copyTo(PredicateSegment predicateSegment) {
        if (this.isPredicate()) {
            if (this.predicate instanceof SubQueryPredicate) {
                SubQueryPredicate subQueryPredicate = (SubQueryPredicate)this.predicate;
                predicateSegment.setPredicate(subQueryPredicate);
            } else {
                predicateSegment.setPredicate(this.predicate);
            }
        } else if (this.children != null) {
            for (PredicateSegment child : this.children) {
                boolean isRoot = child.isRoot();
                if (child instanceof AndPredicateSegment) {
                    AndPredicateSegment andPredicateSegment = new AndPredicateSegment(isRoot);
                    predicateSegment.addPredicateSegment(andPredicateSegment);
                    child.copyTo(andPredicateSegment);
                    continue;
                }
                if (!(child instanceof OrPredicateSegment)) continue;
                OrPredicateSegment orPredicateSegment = new OrPredicateSegment(isRoot);
                predicateSegment.addPredicateSegment(orPredicateSegment);
                child.copyTo(orPredicateSegment);
            }
        }
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        if (this.isPredicate()) {
            return this.predicate.toSQL(toSQLContext);
        }
        if (this.children != null) {
            StringBuilder sql = new StringBuilder();
            boolean allAnd = true;
            boolean allOr = true;
            for (PredicateSegment child : this.children) {
                if (!child.isNotEmpty()) continue;
                if (child instanceof AndPredicateSegment) {
                    allOr = false;
                    if (sql.length() != 0) {
                        sql.append(AndPredicateSegment.AND);
                    }
                    sql.append(child.toSQL(toSQLContext));
                    continue;
                }
                if (!(child instanceof OrPredicateSegment)) continue;
                allAnd = false;
                if (sql.length() != 0) {
                    sql.append(OrPredicateSegment.OR);
                }
                sql.append(child.toSQL(toSQLContext));
            }
            if (sql.length() != 0) {
                if (this.root && (allAnd || allOr)) {
                    return sql.toString();
                }
                if (this.children.size() == 1) {
                    return sql.toString();
                }
                return "(" + sql + ")";
            }
        }
        return "";
    }
}

