/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnValue2Segment;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuesPredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class ColumnCollectionPredicate
implements ValuesPredicate,
ShardingPredicate {
    private final Collection<ColumnValue2Segment> collection;
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;
    private final Column2Segment column2Segment;

    public ColumnCollectionPredicate(Column2Segment column2Segment, Collection<ColumnValue2Segment> collection, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.column2Segment = column2Segment;
        this.collection = collection;
        this.compare = compare;
        this.expressionContext = expressionContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        if (EasyCollectionUtil.isEmpty(this.collection)) {
            if (SQLPredicateCompareEnum.IN == this.compare) {
                return "1 = 2";
            }
            if (SQLPredicateCompareEnum.NOT_IN == this.compare) {
                return "1 = 1";
            }
            throw new UnsupportedOperationException();
        }
        String sqlColumnSegment = this.column2Segment.toSQL(toSQLContext);
        String compareSQL = this.compare.getSQL();
        StringBuilder sql = new StringBuilder();
        sql.append(sqlColumnSegment).append(" ").append(compareSQL).append(" (");
        Iterator<ColumnValue2Segment> iterator = this.collection.iterator();
        ColumnValue2Segment firstColumnValue2Segment = iterator.next();
        sql.append(firstColumnValue2Segment.toSQL(toSQLContext));
        while (iterator.hasNext()) {
            ColumnValue2Segment columnValue2Segment = iterator.next();
            sql.append(",").append(columnValue2Segment.toSQL(toSQLContext));
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public TableAvailable getTable() {
        return this.column2Segment.getTable();
    }

    @Override
    public String getPropertyName() {
        return this.column2Segment.getColumnMetadata().getPropertyName();
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        return new ColumnCollectionPredicate(this.column2Segment, this.collection, this.compare, this.expressionContext);
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public Collection<SQLParameter> getParameters() {
        if (EasyCollectionUtil.isEmpty(this.collection)) {
            return Collections.emptyList();
        }
        ArrayList<SQLParameter> sqlParameters = new ArrayList<SQLParameter>(this.collection.size());
        for (ColumnValue2Segment o : this.collection) {
            sqlParameters.add(o.getSQLParameter());
        }
        return sqlParameters;
    }
}

