/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.api.select.Query;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.SubQueryPredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.visitor.TableVisitor;

public class ColumnInSubQueryPredicate
implements SubQueryPredicate {
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;
    private final Query<?> subQuery;
    private final Column2Segment column2Segment;

    public ColumnInSubQueryPredicate(Column2Segment column2Segment, Query<?> subQuery, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.column2Segment = column2Segment;
        this.subQuery = subQuery;
        this.compare = compare;
        this.expressionContext = expressionContext;
    }

    @Override
    public TableAvailable getTable() {
        return this.column2Segment.getTable();
    }

    @Override
    public String getPropertyName() {
        return this.column2Segment.getColumnMetadata().getPropertyName();
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        String sqlColumnSegment = this.column2Segment.toSQL(toSQLContext);
        StringBuilder sql = new StringBuilder();
        sql.append(sqlColumnSegment).append(" ").append(this.compare.getSQL()).append(" (");
        String subQueryableSQL = this.subQuery.toSQL(toSQLContext);
        sql.append(subQueryableSQL).append(")");
        return sql.toString();
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public Query<?> getSubQuery() {
        return this.subQuery;
    }

    @Override
    public SubQueryPredicate cloneSubQueryPredicate() {
        return new ColumnInSubQueryPredicate(this.column2Segment, this.subQuery.cloneQueryable(), this.compare, this.expressionContext);
    }

    @Override
    public void accept(TableVisitor visitor) {
        SubQueryPredicate.super.accept(visitor);
        this.subQuery.getSQLEntityExpressionBuilder().accept(visitor);
    }
}

