/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLKeywordEnum;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnValue2Segment;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuesPredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.List;

public class ColumnMultiCollectionPredicate
implements ValuesPredicate,
ShardingPredicate {
    private final List<Column2Segment> column2Segments;
    private final List<List<ColumnValue2Segment>> collections;
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;
    private final TableAvailable table;

    public ColumnMultiCollectionPredicate(TableAvailable table, List<Column2Segment> column2Segments, List<List<ColumnValue2Segment>> collections, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.table = table;
        this.column2Segments = column2Segments;
        this.collections = collections;
        this.compare = compare;
        this.expressionContext = expressionContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        if (EasyCollectionUtil.isEmpty(this.collections)) {
            if (SQLPredicateCompareEnum.IN == this.compare) {
                return "1 = 2";
            }
            throw new UnsupportedOperationException();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("(");
        int i = 0;
        for (List<ColumnValue2Segment> collection : this.collections) {
            if (i != 0) {
                sql.append(" ").append(SQLKeywordEnum.OR.toSQL()).append(" ");
            }
            this.appendProperty(sql, toSQLContext, collection);
            ++i;
        }
        sql.append(")");
        return sql.toString();
    }

    private void appendProperty(StringBuilder sql, ToSQLContext toSQLContext, List<ColumnValue2Segment> vals) {
        sql.append("(");
        int i = 0;
        for (Column2Segment column2Segment : this.column2Segments) {
            String sqlColumnSegment = column2Segment.toSQL(toSQLContext);
            ColumnValue2Segment val = vals.get(i);
            if (i != 0) {
                sql.append(" ").append(SQLKeywordEnum.AND.toSQL()).append(" ");
            }
            sql.append(sqlColumnSegment).append(" ").append(SQLPredicateCompareEnum.EQ.getSQL()).append(val.toSQL(toSQLContext));
            ++i;
        }
        sql.append(")");
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        return new ColumnMultiCollectionPredicate(this.table, this.column2Segments, this.collections, this.compare, this.expressionContext);
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public Collection<SQLParameter> getParameters() {
        throw new UnsupportedOperationException();
    }
}

