/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnValue2Segment;
import com.easy.query.core.expression.segment.condition.predicate.ColumnCollectionPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ColumnMultiCollectionPredicate;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuesPredicate;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyColumnSegmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ColumnRelationCollectionPredicate
implements ValuesPredicate,
ShardingPredicate {
    private final List<List<Object>> relationIds;
    private final SQLPredicateCompare compare;
    private final ExpressionContext expressionContext;
    private final TableAvailable table;
    private final String[] propertyNames;
    private final ValuesPredicate valuesPredicate;

    public ColumnRelationCollectionPredicate(TableAvailable table, String[] propertyNames, List<List<Object>> relationIds, SQLPredicateCompare compare, ExpressionContext expressionContext) {
        this.table = table;
        this.propertyNames = propertyNames;
        this.relationIds = relationIds;
        this.compare = compare;
        this.expressionContext = expressionContext;
        this.valuesPredicate = this.getValuesPredicate();
    }

    private Collection<Object> getSingleFromNestCollection(List<List<Object>> collection) {
        ArrayList<Object> result = new ArrayList<Object>(collection.size());
        for (List<Object> objects : collection) {
            if (objects == null) {
                throw new EasyQueryInvalidOperationException("nest collection has null element");
            }
            if (objects.size() != 1) {
                throw new EasyQueryInvalidOperationException("nest collection element.size() != 1");
            }
            result.add(EasyCollectionUtil.first(objects));
        }
        return result;
    }

    private ValuesPredicate getValuesPredicate() {
        if (this.propertyNames.length == 1) {
            Collection<Object> collection = this.getSingleFromNestCollection(this.relationIds);
            ColumnMetadata columnMetadata = this.table.getEntityMetadata().getColumnNotNull(this.propertyNames[0]);
            Column2Segment column2Segment = EasyColumnSegmentUtil.createColumn2Segment(this.table, columnMetadata, this.expressionContext);
            List<ColumnValue2Segment> columnValue2Segments = EasyCollectionUtil.select(collection, (o, i) -> EasyColumnSegmentUtil.createColumnCompareValue2Segment(this.table, columnMetadata, this.expressionContext, o));
            return new ColumnCollectionPredicate(column2Segment, columnValue2Segments, this.compare, this.expressionContext);
        }
        List<Column2Segment> column2Segments = Arrays.stream(this.propertyNames).map(o -> {
            ColumnMetadata columnMetadata = this.table.getEntityMetadata().getColumnNotNull((String)o);
            return EasyColumnSegmentUtil.createColumn2Segment(this.table, columnMetadata, this.expressionContext);
        }).collect(Collectors.toList());
        List<List<ColumnValue2Segment>> columnValue2Segments = EasyCollectionUtil.select(this.relationIds, (innerCollections, i) -> EasyCollectionUtil.select(innerCollections, (o, ii) -> EasyColumnSegmentUtil.createColumnCompareValue2Segment(this.table, ((Column2Segment)column2Segments.get(ii)).getColumnMetadata(), this.expressionContext, o)));
        return new ColumnMultiCollectionPredicate(this.table, column2Segments, columnValue2Segments, this.compare, this.expressionContext);
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        return this.valuesPredicate.toSQL(toSQLContext);
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        return new ColumnRelationCollectionPredicate(this.table, this.propertyNames, this.relationIds, this.compare, this.expressionContext);
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public Collection<SQLParameter> getParameters() {
        throw new UnsupportedOperationException();
    }
}

