/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.condition.predicate;

import com.easy.query.core.basic.jdbc.parameter.MapSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuePredicate;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLUtil;

public class MapColumnValuePredicate
implements ValuePredicate,
ShardingPredicate {
    private final TableAvailable table;
    private final String columnName;
    private final SQLPredicateCompare compare;
    private final QueryRuntimeContext runtimeContext;

    public MapColumnValuePredicate(TableAvailable table, String columnName, SQLPredicateCompare compare, QueryRuntimeContext runtimeContext) {
        this.table = table;
        this.columnName = columnName;
        this.compare = compare;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        SQLParameter sqlParameter = this.getParameter();
        String sqlColumnSegment = EasySQLExpressionUtil.getQuoteName(this.runtimeContext, this.columnName);
        EasySQLUtil.addParameter(toSQLContext, sqlParameter);
        return sqlColumnSegment + " " + this.compare.getSQL() + " ?";
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String getPropertyName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Predicate cloneSQLColumnSegment() {
        return new MapColumnValuePredicate(this.table, this.columnName, this.compare, this.runtimeContext);
    }

    @Override
    public SQLPredicateCompare getOperator() {
        return this.compare;
    }

    @Override
    public SQLParameter getParameter() {
        return new MapSQLParameter(this.columnName, true);
    }
}

