/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnSegment;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;

public class ColumnSegmentImpl
implements ColumnSegment {
    protected final Column2Segment column2Segment;
    protected String alias;

    public ColumnSegmentImpl(Column2Segment column2Segment, String alias) {
        this.column2Segment = column2Segment;
        this.alias = alias;
    }

    @Override
    public TableAvailable getTable() {
        return this.column2Segment.getTable();
    }

    @Override
    public String getPropertyName() {
        return this.column2Segment.getColumnMetadata().getPropertyName();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        String sqlOwnerColumn = this.column2Segment.toSQL(toSQLContext);
        if (this.getAlias() == null) {
            return sqlOwnerColumn;
        }
        return sqlOwnerColumn + " AS " + EasySQLExpressionUtil.getQuoteName(this.column2Segment.getExpressionContext().getRuntimeContext(), this.getAlias());
    }

    @Override
    public ColumnMetadata getColumnMetadata() {
        return this.column2Segment.getColumnMetadata();
    }

    @Override
    public ColumnSegment cloneSQLColumnSegment() {
        return new ColumnSegmentImpl(this.column2Segment, this.alias);
    }
}

