/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.enums.SQLKeywordEnum;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.ReverseOrderBySegment;
import com.easy.query.core.expression.segment.impl.ColumnSegmentImpl;

public class OrderColumnSegmentImpl
extends ColumnSegmentImpl
implements OrderBySegment,
ReverseOrderBySegment {
    private final boolean asc;
    private boolean reverse;

    public OrderColumnSegmentImpl(Column2Segment column2Segment, boolean asc) {
        super(column2Segment, null);
        this.asc = asc;
        this.reverse = false;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        String sqlColumnSegment = this.column2Segment.toSQL(toSQLContext);
        StringBuilder sql = new StringBuilder().append(sqlColumnSegment);
        if (this.getOrderByAsc()) {
            sql.append(" ").append(SQLKeywordEnum.ASC.toSQL());
        } else {
            sql.append(" ").append(SQLKeywordEnum.DESC.toSQL());
        }
        return sql.toString();
    }

    @Override
    public boolean isAsc() {
        return this.asc;
    }

    private boolean getOrderByAsc() {
        return this.isReverse() != this.isAsc();
    }

    @Override
    public void reverseOrder() {
        this.reverse = true;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }
}

