/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.segment.SQLEntityAliasSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.SelectCountDistinctSegment;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.stream.Collectors;

public class SelectCountDistinctSegmentImpl
implements SelectCountDistinctSegment {
    private final Collection<SQLSegment> sqlSegments;

    public SelectCountDistinctSegmentImpl(Collection<SQLSegment> sqlSegments) {
        this.sqlSegments = sqlSegments;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        if (EasyCollectionUtil.isEmpty(this.sqlSegments)) {
            return "COUNT(*)";
        }
        String distinctColumns = this.sqlSegments.stream().map(o -> {
            SQLEntityAliasSegment aliasSegment;
            String alias;
            if (o instanceof SQLEntityAliasSegment && (alias = (aliasSegment = (SQLEntityAliasSegment)o).getAlias()) != null) {
                aliasSegment.setAlias(null);
                String sql = o.toSQL(toSQLContext);
                aliasSegment.setAlias(alias);
                return sql;
            }
            return o.toSQL(toSQLContext);
        }).collect(Collectors.joining(","));
        return "COUNT(DISTINCT " + distinctColumns + ")";
    }
}

