/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.segment.index;

import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import java.util.Objects;

public class EntitySegmentComparer {
    private final Class<?> entityClass;
    private final String propertyName;
    private boolean inSegment;

    public EntitySegmentComparer(Class<?> entityClass, String propertyName) {
        this.entityClass = entityClass;
        this.propertyName = propertyName;
        this.inSegment = false;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void visit(SQLSegment other) {
        SQLEntitySegment otherSegment;
        EntitySegmentComparer otherSegmentComparer;
        if (!this.inSegment && other instanceof SQLEntitySegment && Objects.equals(this, otherSegmentComparer = new EntitySegmentComparer((otherSegment = (SQLEntitySegment)other).getTable().getEntityClass(), otherSegment.getPropertyName()))) {
            this.inSegment = true;
        }
    }

    public boolean isInSegment() {
        return this.inSegment;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EntitySegmentComparer that = (EntitySegmentComparer)object;
        return Objects.equals(this.entityClass, that.entityClass) && Objects.equals(this.propertyName, that.propertyName);
    }

    public int hashCode() {
        return Objects.hash(this.entityClass, this.propertyName);
    }
}

