/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.MultiToTableContext;
import com.easy.query.core.expression.sql.SingleToTableContext;
import com.easy.query.core.expression.sql.TableAliasSchema;
import com.easy.query.core.expression.sql.ToTableContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TableContext {
    private final Map<TableAvailable, TableAliasSchema> aliasMapping = new LinkedHashMap<TableAvailable, TableAliasSchema>();

    public boolean containsTable(TableAvailable table) {
        return this.aliasMapping.containsKey(table);
    }

    public void extract(TableContext otherTableContext) {
        for (Map.Entry<TableAvailable, TableAliasSchema> aliasSchemaEntry : otherTableContext.aliasMapping.entrySet()) {
            this.addTable(aliasSchemaEntry.getKey());
        }
    }

    public void addTable(TableAvailable table) {
        int size = this.aliasMapping.size();
        this.aliasMapping.putIfAbsent(table, new TableAliasSchema(table, size));
    }

    public boolean isEmpty() {
        return this.aliasMapping.isEmpty();
    }

    public void copyTo(TableContext tableContext) {
        for (Map.Entry<TableAvailable, TableAliasSchema> aliasSchemaEntry : this.aliasMapping.entrySet()) {
            tableContext.addTable(aliasSchemaEntry.getKey());
        }
    }

    public ToTableContext getToTableContext(String alias) {
        int mappingSize = this.aliasMapping.size();
        if (mappingSize == 1) {
            TableAliasSchema tableAliasSchema = EasyCollectionUtil.first(this.aliasMapping.values());
            if (tableAliasSchema.getTable().isAnonymous() || tableAliasSchema.getTable().hasAlias()) {
                String tableAlias = tableAliasSchema.getTableAlias(alias);
                return new SingleToTableContext(tableAliasSchema.getTable(), tableAlias, alias, this.aliasMapping);
            }
            return new SingleToTableContext(tableAliasSchema.getTable(), null, alias, this.aliasMapping);
        }
        HashMap<TableAvailable, String> result = new HashMap<TableAvailable, String>(mappingSize);
        int i = 0;
        boolean firstHasAlias = false;
        for (Map.Entry<TableAvailable, TableAliasSchema> aliasSchemaEntry : this.aliasMapping.entrySet()) {
            TableAvailable table = aliasSchemaEntry.getKey();
            TableAliasSchema tableAliasSchema = aliasSchemaEntry.getValue();
            String tableAlias = tableAliasSchema.getTableAlias(alias);
            if (i == 0 && (tableAliasSchema.getTable().isAnonymous() || tableAliasSchema.getTable().hasAlias())) {
                firstHasAlias = true;
            }
            result.put(table, tableAlias);
            ++i;
        }
        return new MultiToTableContext(result, firstHasAlias, alias, this.aliasMapping);
    }
}

