/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.MultiTableTypeEnum;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.ColumnSetter;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.metadata.EntityMetadata;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class DefaultTableExpressionBuilder
implements EntityTableExpressionBuilder {
    protected final TableAvailable entityTable;
    protected final MultiTableTypeEnum multiTableType;
    protected final QueryRuntimeContext runtimeContext;
    protected PredicateSegment on;
    protected Supplier<Boolean> tableLogicDel;
    protected Function<String, String> tableNameAs;
    protected Function<String, String> schemaAs;
    protected Function<String, String> linkAs;
    protected BiFunction<String, String, String> segmentAs;

    public DefaultTableExpressionBuilder(TableAvailable entityTable, MultiTableTypeEnum multiTableType, QueryRuntimeContext runtimeContext) {
        this.entityTable = entityTable;
        this.multiTableType = multiTableType;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.entityTable.getEntityMetadata();
    }

    @Override
    public String getColumnName(String propertyName) {
        return this.entityTable.getColumnName(propertyName);
    }

    @Override
    public void setTableNameAs(Function<String, String> tableNameAs) {
        this.tableNameAs = tableNameAs;
    }

    @Override
    public void setTableLogicDelete(Supplier<Boolean> tableLogicDel) {
        this.tableLogicDel = tableLogicDel;
    }

    @Override
    public void setSchemaAs(Function<String, String> schemaAs) {
        this.schemaAs = schemaAs;
    }

    @Override
    public void setTableLinkAs(Function<String, String> linkAs) {
        this.linkAs = linkAs;
    }

    @Override
    public void setTableSegmentAs(BiFunction<String, String, String> segmentAs) {
        this.segmentAs = segmentAs;
    }

    @Override
    public void asAlias(String alias) {
        this.entityTable.asAlias(alias);
    }

    @Override
    public SQLExpression1<WherePredicate<Object>> getLogicDeleteQueryFilterExpression() {
        Boolean logicDel;
        if (this.getEntityMetadata().enableLogicDelete() && ((logicDel = this.tableLogicDelValue()) == null || logicDel.booleanValue())) {
            return this.getEntityMetadata().getLogicDeleteMetadata().getLogicDeletePredicateFilterExpression();
        }
        return null;
    }

    private Boolean tableLogicDelValue() {
        if (this.tableLogicDel == null) {
            return null;
        }
        return this.tableLogicDel.get();
    }

    @Override
    public SQLExpression1<ColumnSetter<Object>> getLogicDeletedSQLExpression() {
        if (this.getEntityMetadata().enableLogicDelete()) {
            return this.getEntityMetadata().getLogicDeleteMetadata().getLogicDeletedSQLExpression();
        }
        return null;
    }

    @Override
    public EntityTableExpressionBuilder copyEntityTableExpressionBuilder() {
        EntityTableExpressionBuilder tableExpressionBuilder = this.runtimeContext.getExpressionBuilderFactory().createEntityTableExpressionBuilder(this.entityTable, this.multiTableType, this.runtimeContext);
        if (this.on != null) {
            this.on.copyTo(tableExpressionBuilder.getOn());
        }
        tableExpressionBuilder.setTableNameAs(this.tableNameAs);
        tableExpressionBuilder.setSchemaAs(this.schemaAs);
        tableExpressionBuilder.setTableLinkAs(this.linkAs);
        tableExpressionBuilder.setTableLogicDelete(this.tableLogicDel);
        tableExpressionBuilder.setTableSegmentAs(this.segmentAs);
        return tableExpressionBuilder;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityTable.getEntityClass();
    }

    @Override
    public PredicateSegment getOn() {
        if (this.on == null) {
            this.on = new AndPredicateSegment(true);
        }
        return this.on;
    }

    @Override
    public boolean hasOn() {
        return this.on != null && this.on.isNotEmpty();
    }

    @Override
    public TableAvailable getEntityTable() {
        return this.entityTable;
    }

    @Override
    public EntityTableSQLExpression toExpression() {
        EntityTableSQLExpression tableSQLExpression = this.runtimeContext.getExpressionFactory().createEntityTableSQLExpression(this.entityTable, this.multiTableType, this.runtimeContext);
        tableSQLExpression.setTableNameAs(this.tableNameAs);
        tableSQLExpression.setSchemaAs(this.schemaAs);
        tableSQLExpression.setLinkAs(this.linkAs);
        tableSQLExpression.setTableSegmentAs(this.segmentAs);
        return tableSQLExpression;
    }
}

