/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.basic.extension.version.VersionStrategy;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.base.ColumnSetter;
import com.easy.query.core.expression.parser.factory.SQLExpressionInvokeFactory;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnValue2Segment;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.SQLEntitySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.UpdateSetSQLBuilderSegment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.ColumnEqualsPropertyPredicate;
import com.easy.query.core.expression.sql.builder.EntityDeleteExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.internal.AbstractPredicateEntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityDeleteSQLExpression;
import com.easy.query.core.expression.sql.expression.EntityPredicateSQLExpression;
import com.easy.query.core.expression.sql.expression.EntityUpdateSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.VersionMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyColumnSegmentUtil;
import java.util.Collection;
import java.util.Objects;

public class DeleteExpressionBuilder
extends AbstractPredicateEntityExpressionBuilder
implements EntityDeleteExpressionBuilder {
    protected final PredicateSegment where;
    protected final boolean expressionDelete;
    protected SQLBuilderSegment whereColumns;

    public DeleteExpressionBuilder(ExpressionContext sqlExpressionContext, Class<?> queryClass, boolean expressionDelete) {
        super(sqlExpressionContext, queryClass);
        this.expressionDelete = expressionDelete;
        this.where = new AndPredicateSegment(true);
    }

    @Override
    public PredicateSegment getWhere() {
        return this.where;
    }

    @Override
    public boolean hasWhere() {
        return this.where.isNotEmpty();
    }

    @Override
    public SQLBuilderSegment getWhereColumns() {
        if (this.whereColumns == null) {
            this.whereColumns = new ProjectSQLBuilderSegmentImpl();
        }
        return this.whereColumns;
    }

    @Override
    public boolean hasWhereColumns() {
        return this.whereColumns != null && this.whereColumns.isNotEmpty();
    }

    private UpdateSetSQLBuilderSegment getUpdateSetSQLBuilderSegment(EntityTableExpressionBuilder table) {
        SQLExpression1<ColumnSetter<Object>> logicDeletedSQLExpression;
        boolean useLogicDelete;
        EntityMetadata entityMetadata = table.getEntityMetadata();
        boolean bl = useLogicDelete = entityMetadata.enableLogicDelete() && this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.LOGIC_DELETE);
        if (useLogicDelete && (logicDeletedSQLExpression = table.getLogicDeletedSQLExpression()) != null) {
            UpdateSetSQLBuilderSegment setSQLSegmentBuilder = new UpdateSetSQLBuilderSegment();
            SQLExpressionInvokeFactory easyQueryLambdaFactory = this.getRuntimeContext().getSQLExpressionInvokeFactory();
            ColumnSetter sqlColumnSetter = easyQueryLambdaFactory.createColumnSetter(table.getEntityTable(), this, setSQLSegmentBuilder);
            logicDeletedSQLExpression.apply(sqlColumnSetter);
            if (entityMetadata.hasVersionColumn()) {
                VersionMetadata versionMetadata = entityMetadata.getVersionMetadata();
                String propertyName = versionMetadata.getPropertyName();
                VersionStrategy easyVersionStrategy = versionMetadata.getEasyVersionStrategy();
                if (this.isExpression()) {
                    Object version = this.getExpressionContext().getVersion();
                    if (Objects.nonNull(version)) {
                        Object nextVersion = easyVersionStrategy.nextVersion(entityMetadata, propertyName, version);
                        sqlColumnSetter.set(propertyName, nextVersion);
                    }
                } else {
                    InsertUpdateSetColumnSQLSegment updateColumnSegment = this.sqlSegmentFactory.createUpdateColumnSegment(table.getEntityTable(), versionMetadata.getPropertyName(), this.getExpressionContext(), easyVersionStrategy);
                    setSQLSegmentBuilder.append(updateColumnSegment);
                }
            }
            return setSQLSegmentBuilder;
        }
        return null;
    }

    protected PredicateSegment buildWherePredicateSegment(EntityTableExpressionBuilder table) {
        EntityMetadata entityMetadata = table.getEntityMetadata();
        PredicateSegment wherePredicate = this.getWhere();
        if (!this.expressionDelete && !this.hasWhere()) {
            if (this.hasWhereColumns()) {
                for (SQLSegment sqlSegment : this.whereColumns.getSQLSegments()) {
                    if (!(sqlSegment instanceof SQLEntitySegment)) {
                        throw new EasyQueryException("where \u8868\u8fbe\u5f0f\u7247\u6bb5\u4e0d\u662fSQLEntitySegment");
                    }
                    SQLEntitySegment sqlEntitySegment = (SQLEntitySegment)sqlSegment;
                    ColumnMetadata columnMetadata = table.getEntityTable().getEntityMetadata().getColumnNotNull(sqlEntitySegment.getPropertyName());
                    Column2Segment column2Segment = EasyColumnSegmentUtil.createColumn2Segment(table.getEntityTable(), columnMetadata, this.getExpressionContext());
                    ColumnValue2Segment columnValue2Segment = EasyColumnSegmentUtil.createColumnValue2Segment(table.getEntityTable(), columnMetadata, this.getExpressionContext(), null);
                    AndPredicateSegment andPredicateSegment = new AndPredicateSegment(new ColumnEqualsPropertyPredicate(column2Segment, columnValue2Segment));
                    wherePredicate.addPredicateSegment(andPredicateSegment);
                }
            } else {
                Collection<String> keyProperties = entityMetadata.getKeyProperties();
                if (keyProperties.isEmpty()) {
                    throw new EasyQueryException("entity:" + EasyClassUtil.getSimpleName(entityMetadata.getEntityClass()) + "  not found primary key properties");
                }
                for (String keyProperty : keyProperties) {
                    ColumnMetadata columnMetadata = table.getEntityTable().getEntityMetadata().getColumnNotNull(keyProperty);
                    Column2Segment column2Segment = EasyColumnSegmentUtil.createColumn2Segment(table.getEntityTable(), columnMetadata, this.getExpressionContext());
                    ColumnValue2Segment columnValue2Segment = EasyColumnSegmentUtil.createColumnValue2Segment(table.getEntityTable(), columnMetadata, this.getExpressionContext(), null);
                    AndPredicateSegment andPredicateSegment = new AndPredicateSegment(new ColumnEqualsPropertyPredicate(column2Segment, columnValue2Segment));
                    wherePredicate.addPredicateSegment(andPredicateSegment);
                }
            }
        }
        if (wherePredicate.isEmpty()) {
            throw new EasyQueryException("'DELETE' statement without 'WHERE'");
        }
        return this.sqlPredicateFilter(table, wherePredicate);
    }

    @Override
    public boolean isExpression() {
        return this.expressionDelete;
    }

    @Override
    public EntityPredicateSQLExpression toExpression() {
        int tableCount = this.getTables().size();
        if (tableCount == 0) {
            throw new EasyQueryException("not found any table in delete expression build.");
        }
        if (tableCount > 1) {
            throw new EasyQueryInvalidOperationException("not support multi table in delete expression build.");
        }
        if (this.expressionDelete) {
            return this.toDeleteExpression();
        }
        return this.toEntityExpression();
    }

    private EntityPredicateSQLExpression toDeleteExpression() {
        if (!this.hasWhere()) {
            throw new EasyQueryException("'DELETE' statement without 'WHERE' clears all data in the table");
        }
        if (this.getTables().isEmpty()) {
            throw new EasyQueryException("not table found for delete");
        }
        EntityTableExpressionBuilder table = this.getTables().get(0);
        UpdateSetSQLBuilderSegment updateSetSQLBuilderSegment = this.getUpdateSetSQLBuilderSegment(table);
        QueryRuntimeContext runtimeContext = this.getRuntimeContext();
        ExpressionFactory expressionFactory = runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, runtimeContext);
        if (updateSetSQLBuilderSegment != null) {
            PredicateSegment where = this.buildWherePredicateSegment(table);
            EntityUpdateSQLExpression easyUpdateSQLExpression = expressionFactory.createEasyUpdateSQLExpression(entitySQLExpressionMetadata, table.toExpression());
            updateSetSQLBuilderSegment.copyTo(easyUpdateSQLExpression.getSetColumns());
            where.copyTo(easyUpdateSQLExpression.getWhere());
            return easyUpdateSQLExpression;
        }
        if (this.expressionContext.isDeleteThrow()) {
            throw new EasyQueryInvalidOperationException("The delete operation cannot be executed because physical deletion is not allowed by default configuration. If physical deletion is needed, please call [.allowDeleteStatement(true)].");
        }
        EntityDeleteSQLExpression easyDeleteSQLExpression = expressionFactory.createEasyDeleteSQLExpression(entitySQLExpressionMetadata, table.toExpression());
        PredicateSegment where = this.buildWherePredicateSegment(table);
        where.copyTo(easyDeleteSQLExpression.getWhere());
        return easyDeleteSQLExpression;
    }

    private EntityPredicateSQLExpression toEntityExpression() {
        EntityTableExpressionBuilder table = this.getTables().get(0);
        PredicateSegment sqlWhere = this.buildWherePredicateSegment(table);
        UpdateSetSQLBuilderSegment updateSetSQLBuilderSegment = this.getUpdateSetSQLBuilderSegment(table);
        QueryRuntimeContext runtimeContext = this.getRuntimeContext();
        ExpressionFactory expressionFactory = runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, runtimeContext);
        if (updateSetSQLBuilderSegment != null) {
            EntityUpdateSQLExpression easyUpdateSQLExpression = expressionFactory.createEasyUpdateSQLExpression(entitySQLExpressionMetadata, table.toExpression());
            updateSetSQLBuilderSegment.copyTo(easyUpdateSQLExpression.getSetColumns());
            sqlWhere.copyTo(easyUpdateSQLExpression.getWhere());
            return easyUpdateSQLExpression;
        }
        if (this.expressionContext.isDeleteThrow()) {
            throw new EasyQueryInvalidOperationException("The delete operation cannot be executed because physical deletion is not allowed by default configuration. If physical deletion is needed, please call [.allowDeleteStatement(true)].");
        }
        EntityDeleteSQLExpression easyDeleteSQLExpression = expressionFactory.createEasyDeleteSQLExpression(entitySQLExpressionMetadata, table.toExpression());
        sqlWhere.copyTo(easyDeleteSQLExpression.getWhere());
        return easyDeleteSQLExpression;
    }

    @Override
    public EntityDeleteExpressionBuilder cloneEntityExpressionBuilder() {
        EntityDeleteExpressionBuilder deleteExpressionBuilder = this.runtimeContext.getExpressionBuilderFactory().createEntityDeleteExpressionBuilder(this.expressionContext, this.queryClass, this.expressionDelete);
        if (this.hasWhere()) {
            this.getWhere().copyTo(deleteExpressionBuilder.getWhere());
        }
        if (this.hasWhereColumns()) {
            this.getWhereColumns().copyTo(deleteExpressionBuilder.getWhereColumns());
        }
        for (EntityTableExpressionBuilder table : this.tables) {
            deleteExpressionBuilder.getTables().add(table.copyEntityTableExpressionBuilder());
        }
        return deleteExpressionBuilder;
    }
}

