/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.segment.InsertUpdateSetColumnSQLSegment;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.segment.impl.InsertUpdateColumnConfigureSegmentImpl;
import com.easy.query.core.expression.sql.builder.ColumnConfigurerContext;
import com.easy.query.core.expression.sql.builder.EntityInsertExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.internal.AbstractEntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityInsertSQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class InsertMapExpressionBuilder
extends AbstractEntityExpressionBuilder
implements EntityInsertExpressionBuilder {
    protected Map<String, ColumnConfigurerContext> columnConfigurers;

    public InsertMapExpressionBuilder(ExpressionContext expressionContext) {
        super(expressionContext, Map.class);
    }

    @Override
    public SQLBuilderSegment getColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLBuilderSegment getDuplicateKeyUpdateColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getDuplicateKeys() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDuplicateKey(String duplicateKey) {
        throw new UnsupportedOperationException();
    }

    private void checkTable() {
        int tableCount = this.getTables().size();
        if (tableCount == 0) {
            throw new EasyQueryException("\u672a\u627e\u5230\u67e5\u8be2\u8868\u4fe1\u606f");
        }
        if (tableCount > 1) {
            throw new EasyQueryException("\u627e\u5230\u591a\u5f20\u8868\u4fe1\u606f");
        }
    }

    private boolean clearIgnoreProperties(Set<String> ignorePropertySet, QueryRuntimeContext runtimeContext, Map<String, Object> map) {
        if (map != null) {
            SQLExecuteStrategyEnum insertStrategy = this.expressionContext.getSQLStrategy();
            if (Objects.equals((Object)SQLExecuteStrategyEnum.DEFAULT, (Object)insertStrategy)) {
                SQLExecuteStrategyEnum globalInsertStrategy = runtimeContext.getQueryConfiguration().getEasyQueryOption().getInsertStrategy();
                this.getCustomIgnoreProperties(ignorePropertySet, globalInsertStrategy, runtimeContext.getEntityMetadataManager(), map);
                return true;
            }
            this.getCustomIgnoreProperties(ignorePropertySet, insertStrategy, runtimeContext.getEntityMetadataManager(), map);
            return true;
        }
        return false;
    }

    private void getCustomIgnoreProperties(Set<String> ignoreUpdateSet, SQLExecuteStrategyEnum updateStrategy, EntityMetadataManager entityMetadataManager, Map<String, Object> map) {
        if (Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) || Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NULL_COLUMNS, (Object)updateStrategy)) {
            Predicate<Object> valuePredicate = Objects.equals((Object)SQLExecuteStrategyEnum.ONLY_NOT_NULL_COLUMNS, (Object)updateStrategy) ? Objects::isNull : Objects::nonNull;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (!valuePredicate.test(value)) continue;
                ignoreUpdateSet.add(entry.getKey());
            }
        }
    }

    @Override
    public EntityInsertSQLExpression toExpression(Object entity) {
        if (!(entity instanceof Map)) {
            throw new UnsupportedOperationException("map insert can not been null");
        }
        this.checkTable();
        Map map = (Map)EasyObjectUtil.typeCastNullable(entity);
        EntityTableExpressionBuilder table = this.getTable(0);
        QueryRuntimeContext runtimeContext = this.getRuntimeContext();
        ExpressionFactory expressionFactory = runtimeContext.getExpressionFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, runtimeContext);
        EntityInsertSQLExpression easyInsertSQLExpression = expressionFactory.createEasyInsertSQLExpression(entitySQLExpressionMetadata, table.toExpression());
        ProjectSQLBuilderSegmentImpl insertCloneColumns = new ProjectSQLBuilderSegmentImpl();
        SQLSegmentFactory sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
        boolean hasConfigure = this.columnConfigurers != null && !this.columnConfigurers.isEmpty();
        HashSet<String> ignorePropertySet = new HashSet<String>(map.size());
        boolean clearIgnoreProperties = this.clearIgnoreProperties(ignorePropertySet, this.getRuntimeContext(), map);
        for (String columnName : map.keySet()) {
            ColumnConfigurerContext columnConfigurerContext;
            if (clearIgnoreProperties && ignorePropertySet.contains(columnName)) continue;
            InsertUpdateSetColumnSQLSegment columnInsertSegment = sqlSegmentFactory.createInsertMapColumnSegment(columnName, runtimeContext);
            if (hasConfigure && (columnConfigurerContext = this.columnConfigurers.get(columnName)) != null) {
                insertCloneColumns.append(new InsertUpdateColumnConfigureSegmentImpl(columnInsertSegment, this.getExpressionContext(), columnConfigurerContext.getSqlSegment(), columnConfigurerContext.getSqlNativeExpressionContext()));
                continue;
            }
            insertCloneColumns.append(columnInsertSegment);
        }
        int insertColumns = insertCloneColumns.getSQLSegments().size();
        if (insertColumns == 0) {
            throw new EasyQueryException("not found insert columns :" + EasyClassUtil.getSimpleName(table.getEntityClass()));
        }
        insertCloneColumns.copyTo(easyInsertSQLExpression.getColumns());
        return easyInsertSQLExpression;
    }

    @Override
    public EntityInsertExpressionBuilder cloneEntityExpressionBuilder() {
        EntityInsertExpressionBuilder insertExpressionBuilder = this.runtimeContext.getExpressionBuilderFactory().createEntityInsertExpressionBuilder(this.expressionContext, this.queryClass);
        if (EasySQLSegmentUtil.isNotEmpty(this.getColumns())) {
            this.getColumns().copyTo(insertExpressionBuilder.getColumns());
        }
        for (EntityTableExpressionBuilder table : this.tables) {
            insertExpressionBuilder.getTables().add(table.copyEntityTableExpressionBuilder());
        }
        if (this.columnConfigurers != null) {
            insertExpressionBuilder.getColumnConfigurer().putAll(this.columnConfigurers);
        }
        return insertExpressionBuilder;
    }

    @Override
    public Map<String, ColumnConfigurerContext> getColumnConfigurer() {
        if (this.columnConfigurers == null) {
            this.columnConfigurers = new HashMap<String, ColumnConfigurerContext>();
        }
        return this.columnConfigurers;
    }
}

