/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.impl;

import com.easy.query.core.common.reverse.ChainReverseEach;
import com.easy.query.core.common.reverse.DefaultReverseEach;
import com.easy.query.core.common.reverse.EmptyReverseEach;
import com.easy.query.core.common.reverse.ReverseEach;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationTableAppendEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.RelationTableKey;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.SelectConstSegment;
import com.easy.query.core.expression.segment.builder.GroupBySQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.OrderBySQLBuilderSegment;
import com.easy.query.core.expression.segment.builder.OrderBySQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.ProjectSQLBuilderSegmentImpl;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.sql.builder.AnonymousEntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.ExpressionTableVisitor;
import com.easy.query.core.expression.sql.builder.SQLEntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.internal.AbstractPredicateEntityExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityQuerySQLExpression;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.SQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.expression.visitor.TableVisitor;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class QueryExpressionBuilder
extends AbstractPredicateEntityExpressionBuilder
implements EntityQueryExpressionBuilder {
    protected PredicateSegment where;
    protected SQLBuilderSegment group;
    protected PredicateSegment having;
    protected OrderBySQLBuilderSegment order;
    protected long offset;
    protected long rows;
    protected boolean distinct;
    protected final SQLBuilderSegment projects = new ProjectSQLBuilderSegmentImpl();

    public QueryExpressionBuilder(ExpressionContext expressionContext, Class<?> queryClass) {
        super(expressionContext, queryClass);
    }

    @Override
    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    @Override
    public SQLBuilderSegment getProjects() {
        return this.projects;
    }

    @Override
    public PredicateSegment getWhere() {
        if (this.where == null) {
            this.where = new AndPredicateSegment(true);
        }
        return this.where;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getRows() {
        return this.rows;
    }

    @Override
    public void setRows(long rows) {
        this.rows = rows;
    }

    @Override
    public boolean hasLimit() {
        return this.rows > 0L;
    }

    @Override
    public boolean hasWhere() {
        return this.where != null && this.where.isNotEmpty();
    }

    @Override
    public PredicateSegment getHaving() {
        if (this.having == null) {
            this.having = new AndPredicateSegment(true);
        }
        return this.having;
    }

    @Override
    public boolean hasHaving() {
        return EasySQLSegmentUtil.isNotEmpty(this.having);
    }

    @Override
    public SQLBuilderSegment getGroup() {
        if (this.group == null) {
            this.group = new GroupBySQLBuilderSegmentImpl();
        }
        return this.group;
    }

    @Override
    public boolean hasGroup() {
        return this.group != null && this.group.isNotEmpty();
    }

    @Override
    public OrderBySQLBuilderSegment getOrder() {
        if (this.order == null) {
            this.order = new OrderBySQLBuilderSegmentImpl();
        }
        return this.order;
    }

    @Override
    public boolean hasOrder() {
        return this.order != null && this.order.isNotEmpty();
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public EntityQuerySQLExpression toExpression() {
        int tableCount = this.getTables().size();
        if (tableCount == 0) {
            throw new EasyQueryException("\u672a\u627e\u5230\u67e5\u8be2\u8868\u4fe1\u606f");
        }
        boolean emptySelect = this.getProjects().isEmpty();
        Iterator<EntityTableExpressionBuilder> iterator = this.getTables().iterator();
        EntityTableExpressionBuilder firstTable = iterator.next();
        if (emptySelect && tableCount == 1 && firstTable instanceof AnonymousEntityTableExpressionBuilder && !(((AnonymousEntityTableExpressionBuilder)firstTable).getEntityQueryExpressionBuilder() instanceof SQLEntityQueryExpressionBuilder)) {
            return (EntityQuerySQLExpression)this.toTableExpressionSQL(firstTable, true);
        }
        QueryRuntimeContext runtimeContext = this.getRuntimeContext();
        ExpressionFactory expressionFactory = runtimeContext.getExpressionFactory();
        SQLSegmentFactory sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
        EntitySQLExpressionMetadata entitySQLExpressionMetadata = new EntitySQLExpressionMetadata(this.expressionContext, runtimeContext);
        EntityQuerySQLExpression easyQuerySQLExpression = expressionFactory.createEasyQuerySQLExpression(entitySQLExpressionMetadata);
        easyQuerySQLExpression.setDistinct(this.isDistinct());
        if (emptySelect) {
            ProjectSQLBuilderSegmentImpl projects;
            if (!this.hasGroup()) {
                projects = new ProjectSQLBuilderSegmentImpl();
                SelectConstSegment selectAllSegment = sqlSegmentFactory.createSelectConstSegment("*");
                projects.append(selectAllSegment);
                easyQuerySQLExpression.setProjects(projects);
            } else {
                projects = new ProjectSQLBuilderSegmentImpl();
                this.getGroup().copyTo(projects);
                easyQuerySQLExpression.setProjects(projects);
            }
        } else {
            easyQuerySQLExpression.setProjects(this.getProjects().cloneSQLBuilder());
        }
        easyQuerySQLExpression.getTables().add((EntityTableSQLExpression)this.toTableExpressionSQL(firstTable, false));
        while (iterator.hasNext()) {
            EntityTableExpressionBuilder table = iterator.next();
            EntityTableSQLExpression tableExpression = (EntityTableSQLExpression)this.toTableExpressionSQL(table, false);
            easyQuerySQLExpression.getTables().add(tableExpression);
            PredicateSegment on = this.getTableOnWithQueryFilter(table);
            if (on == null || !on.isNotEmpty()) continue;
            tableExpression.setOn(on);
        }
        PredicateSegment where = this.getSQLWhereWithQueryFilter();
        if (where != null && where.isNotEmpty()) {
            easyQuerySQLExpression.setWhere(where);
        }
        easyQuerySQLExpression.setGroup(this.getGroup().cloneSQLBuilder());
        easyQuerySQLExpression.setHaving(this.getHaving().clonePredicateSegment());
        easyQuerySQLExpression.setOrder(this.getOrder().cloneSQLBuilder());
        easyQuerySQLExpression.setOffset(this.getOffset());
        easyQuerySQLExpression.setRows(this.getRows());
        RelationTableAppendEnum relationTableAppend = this.easyQueryOption.getRelationTableAppend();
        if (this.hasRelationTables()) {
            ExpressionTableVisitor expressionTableVisitor = new ExpressionTableVisitor();
            this.accept(expressionTableVisitor);
            ArrayList tableSQLExpressions = new ArrayList();
            ReverseEach reverseEach = EmptyReverseEach.EMPTY;
            for (Map.Entry<RelationTableKey, EntityTableExpressionBuilder> relationTableKV : this.getRelationTables().entrySet()) {
                RelationTableKey key = relationTableKV.getKey();
                EntityTableExpressionBuilder value = relationTableKV.getValue();
                TableAvailable entityTable = value.getEntityTable();
                reverseEach = new ChainReverseEach(reverseEach, new DefaultReverseEach(() -> {
                    if (relationTableAppend == RelationTableAppendEnum.DEFAULT || expressionTableVisitor.containsTable(entityTable)) {
                        EntityTableSQLExpression tableExpression = (EntityTableSQLExpression)this.toTableExpressionSQL(value, false);
                        PredicateSegment on = this.getTableOnWithQueryFilter(value);
                        if (on != null && on.isNotEmpty()) {
                            tableExpression.setOn(on);
                        }
                        EasySQLSegmentUtil.tableVisit(on, (TableVisitor)expressionTableVisitor);
                        tableSQLExpressions.add(tableExpression);
                    }
                }));
            }
            reverseEach.invoke();
            if (EasyCollectionUtil.isNotEmpty(tableSQLExpressions)) {
                for (int i = tableSQLExpressions.size() - 1; i >= 0; --i) {
                    EntityTableSQLExpression tableExpression = (EntityTableSQLExpression)tableSQLExpressions.get(i);
                    easyQuerySQLExpression.getTables().add(tableExpression);
                }
            }
        }
        return easyQuerySQLExpression;
    }

    protected SQLExpression toTableExpressionSQL(EntityTableExpressionBuilder entityTableExpressionBuilder, boolean onlySingleAnonymousTable) {
        if (entityTableExpressionBuilder instanceof AnonymousEntityTableExpressionBuilder) {
            EntityQueryExpressionBuilder sqlEntityQueryExpression = ((AnonymousEntityTableExpressionBuilder)entityTableExpressionBuilder).getEntityQueryExpressionBuilder();
            return onlySingleAnonymousTable ? sqlEntityQueryExpression.toExpression() : entityTableExpressionBuilder.toExpression();
        }
        return entityTableExpressionBuilder.toExpression();
    }

    protected PredicateSegment getTableOnWithQueryFilter(EntityTableExpressionBuilder table) {
        return this.sqlPredicateFilter(table, table.hasOn() ? table.getOn() : null);
    }

    protected PredicateSegment getSQLWhereWithQueryFilter() {
        EntityTableExpressionBuilder table = this.getTable(0);
        return this.sqlPredicateFilter(table, this.hasWhere() ? this.getWhere() : null);
    }

    @Override
    public EntityQueryExpressionBuilder cloneEntityExpressionBuilder() {
        EntityQueryExpressionBuilder queryExpressionBuilder = this.runtimeContext.getExpressionBuilderFactory().createEntityQueryExpressionBuilder(this.expressionContext.cloneExpressionContext(), this.queryClass);
        if (this.hasWhere()) {
            this.getWhere().copyTo(queryExpressionBuilder.getWhere());
        }
        if (this.hasGroup()) {
            this.getGroup().copyTo(queryExpressionBuilder.getGroup());
        }
        if (this.hasHaving()) {
            this.getHaving().copyTo(queryExpressionBuilder.getHaving());
        }
        if (this.hasOrder()) {
            this.getOrder().copyTo(queryExpressionBuilder.getOrder());
        }
        this.getProjects().copyTo(queryExpressionBuilder.getProjects());
        queryExpressionBuilder.setOffset(this.offset);
        queryExpressionBuilder.setRows(this.rows);
        queryExpressionBuilder.setDistinct(this.distinct);
        for (EntityTableExpressionBuilder entityTableExpressionBuilder : this.tables) {
            queryExpressionBuilder.getTables().add(entityTableExpressionBuilder.copyEntityTableExpressionBuilder());
        }
        if (this.relationTables != null) {
            for (Map.Entry entry : this.relationTables.entrySet()) {
                queryExpressionBuilder.getRelationTables().put((RelationTableKey)entry.getKey(), ((EntityTableExpressionBuilder)entry.getValue()).copyEntityTableExpressionBuilder());
            }
        }
        return queryExpressionBuilder;
    }

    @Override
    public void accept(TableVisitor visitor) {
        for (EntityTableExpressionBuilder table : this.getTables()) {
            if (table instanceof AnonymousEntityTableExpressionBuilder) {
                EntityQueryExpressionBuilder entityQueryExpressionBuilder = ((AnonymousEntityTableExpressionBuilder)table).getEntityQueryExpressionBuilder();
                entityQueryExpressionBuilder.accept(visitor);
                continue;
            }
            EasySQLSegmentUtil.tableVisit(table.getOn(), visitor);
        }
        EasySQLSegmentUtil.tableVisit(this.projects, visitor);
        EasySQLSegmentUtil.tableVisit(this.where, visitor);
        EasySQLSegmentUtil.tableVisit(this.order, visitor);
        EasySQLSegmentUtil.tableVisit(this.group, visitor);
        EasySQLSegmentUtil.tableVisit(this.having, visitor);
    }
}

