/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.internal;

import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.expression.RelationEntityTableAvailable;
import com.easy.query.core.expression.RelationTableKey;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.sql.builder.EntityExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractEntityExpressionBuilder
implements EntityExpressionBuilder {
    protected final ExpressionContext expressionContext;
    protected final QueryRuntimeContext runtimeContext;
    protected final SQLSegmentFactory sqlSegmentFactory;
    protected final EasyQueryOption easyQueryOption;
    protected final Class<?> queryClass;
    protected final List<EntityTableExpressionBuilder> tables;
    protected Map<RelationTableKey, EntityTableExpressionBuilder> relationTables;

    public AbstractEntityExpressionBuilder(ExpressionContext expressionContext, Class<?> queryClass) {
        this.expressionContext = expressionContext;
        this.runtimeContext = expressionContext.getRuntimeContext();
        this.queryClass = queryClass;
        this.tables = new ArrayList<EntityTableExpressionBuilder>();
        this.sqlSegmentFactory = this.runtimeContext.getSQLSegmentFactory();
        this.easyQueryOption = this.runtimeContext.getQueryConfiguration().getEasyQueryOption();
    }

    @Override
    public Class<?> getQueryClass() {
        return this.queryClass;
    }

    @Override
    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.expressionContext.getRuntimeContext();
    }

    @Override
    public void addSQLEntityTableExpression(EntityTableExpressionBuilder tableExpression) {
        if (tableExpression.getEntityTable().getEntityMetadata().isSharding()) {
            this.expressionContext.useSharding();
        }
        this.expressionContext.getTableContext().addTable(tableExpression.getEntityTable());
        this.tables.add(tableExpression);
    }

    @Override
    public EntityTableExpressionBuilder addRelationEntityTableExpression(RelationTableKey relationTableKey, Function<RelationTableKey, EntityTableExpressionBuilder> tableExpressionSupplier) {
        EntityTableExpressionBuilder entityTableExpressionBuilder;
        if (this.relationTables == null) {
            this.relationTables = new LinkedHashMap<RelationTableKey, EntityTableExpressionBuilder>();
        }
        if ((entityTableExpressionBuilder = this.relationTables.get(relationTableKey)) != null) {
            return entityTableExpressionBuilder;
        }
        EntityTableExpressionBuilder tableExpression = tableExpressionSupplier.apply(relationTableKey);
        if (tableExpression.getEntityTable().getEntityMetadata().isSharding()) {
            this.expressionContext.useSharding();
        }
        this.expressionContext.getTableContext().addTable(tableExpression.getEntityTable());
        if (tableExpression.getEntityTable() instanceof RelationEntityTableAvailable) {
            this.relationTables.put(relationTableKey, tableExpression);
            return tableExpression;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EntityTableExpressionBuilder> getTables() {
        return this.tables;
    }

    @Override
    public Map<RelationTableKey, EntityTableExpressionBuilder> getRelationTables() {
        if (this.relationTables == null) {
            this.relationTables = new LinkedHashMap<RelationTableKey, EntityTableExpressionBuilder>();
        }
        return this.relationTables;
    }

    @Override
    public boolean hasRelationTables() {
        return this.relationTables != null && !this.relationTables.isEmpty();
    }

    @Override
    public void setLogicDelete(boolean logicDelete) {
        if (logicDelete) {
            this.expressionContext.getBehavior().addBehavior(EasyBehaviorEnum.LOGIC_DELETE);
        } else {
            this.expressionContext.getBehavior().removeBehavior(EasyBehaviorEnum.LOGIC_DELETE);
        }
    }
}

