/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.internal;

import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.interceptor.PredicateFilterInterceptor;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.RelationTableAvailable;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.expression.parser.factory.SQLExpressionInvokeFactory;
import com.easy.query.core.expression.segment.Column2Segment;
import com.easy.query.core.expression.segment.ColumnValue2Segment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.ColumnEqualsPropertyPredicate;
import com.easy.query.core.expression.sql.builder.AnonymousEntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.builder.LambdaEntityExpressionBuilder;
import com.easy.query.core.expression.sql.builder.internal.AbstractEntityExpressionBuilder;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.VersionMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyColumnSegmentUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class AbstractPredicateEntityExpressionBuilder
extends AbstractEntityExpressionBuilder
implements LambdaEntityExpressionBuilder {
    public AbstractPredicateEntityExpressionBuilder(ExpressionContext expressionContext, Class<?> queryClass) {
        super(expressionContext, queryClass);
    }

    protected boolean useLogicDelete(EntityMetadata entityMetadata) {
        return entityMetadata.enableLogicDelete() && this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.LOGIC_DELETE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PredicateSegment sqlPredicateFilter(EntityTableExpressionBuilder table, PredicateSegment originalPredicate) {
        List<PredicateFilterInterceptor> predicateFilterInterceptors;
        boolean ignoreVersion;
        if (table instanceof AnonymousEntityTableExpressionBuilder) return originalPredicate;
        EntityMetadata entityMetadata = table.getEntityMetadata();
        AndPredicateSegment predicateSegment = new AndPredicateSegment(true);
        SQLExpressionInvokeFactory easyQueryLambdaFactory = this.getRuntimeContext().getSQLExpressionInvokeFactory();
        TableAvailable entityTable = table.getEntityTable();
        WherePredicate<Object> sqlPredicate = easyQueryLambdaFactory.createWherePredicate(entityTable, this, predicateSegment);
        if (this.useLogicDelete(entityMetadata)) {
            this.invokeTableLogicDelete(table, sqlPredicate);
        }
        if (!this.isQuery() && entityMetadata.hasVersionColumn() && !(ignoreVersion = this.expressionContext.getBehavior().hasBehavior(EasyBehaviorEnum.IGNORE_VERSION))) {
            VersionMetadata versionMetadata = entityMetadata.getVersionMetadata();
            if (this.isExpression()) {
                Object version = this.expressionContext.getVersion();
                if (!Objects.nonNull(version)) throw new EasyQueryInvalidOperationException("entity:" + EasyClassUtil.getSimpleName(table.getEntityClass()) + " has version expression not found version");
                sqlPredicate.eq(versionMetadata.getPropertyName(), version);
            } else {
                ColumnMetadata columnMetadata = entityTable.getEntityMetadata().getColumnNotNull(versionMetadata.getPropertyName());
                Column2Segment column2Segment = EasyColumnSegmentUtil.createColumn2Segment(entityTable, columnMetadata, this.getExpressionContext());
                ColumnValue2Segment columnValue2Segment = EasyColumnSegmentUtil.createColumnValue2Segment(entityTable, columnMetadata, this.getExpressionContext(), null);
                AndPredicateSegment versionPredicateSegment = new AndPredicateSegment(new ColumnEqualsPropertyPredicate(column2Segment, columnValue2Segment));
                predicateSegment.addPredicateSegment(versionPredicateSegment);
            }
        }
        if (EasyCollectionUtil.isNotEmpty(predicateFilterInterceptors = entityMetadata.getPredicateFilterInterceptors())) {
            Predicate<Interceptor> interceptorFilter = this.expressionContext.getInterceptorFilter();
            for (PredicateFilterInterceptor predicateFilterInterceptor : predicateFilterInterceptors) {
                if (!interceptorFilter.test(predicateFilterInterceptor)) continue;
                predicateFilterInterceptor.configure(entityMetadata.getEntityClass(), this, sqlPredicate);
            }
        }
        if (!predicateSegment.isNotEmpty()) return originalPredicate;
        if (originalPredicate == null || !originalPredicate.isNotEmpty()) return predicateSegment;
        predicateSegment.addPredicateSegment(originalPredicate);
        return predicateSegment;
    }

    private Boolean relationLogicDelete(RelationTableAvailable relationTable) {
        if (!this.expressionContext.hasRelationLogicDelete()) {
            return null;
        }
        return this.expressionContext.getRelationLogicDelete().apply(relationTable.getEntityClass());
    }

    private void invokeTableLogicDelete(EntityTableExpressionBuilder table, WherePredicate<Object> sqlPredicate) {
        RelationTableAvailable relationTable;
        Boolean relationLogicDel;
        TableAvailable entityTable = table.getEntityTable();
        if (this.expressionContext.hasRelationLogicDelete() && entityTable instanceof RelationTableAvailable && (relationLogicDel = this.relationLogicDelete(relationTable = (RelationTableAvailable)entityTable)) != null && !relationLogicDel.booleanValue()) {
            return;
        }
        SQLExpression1<WherePredicate<Object>> logicDeleteQueryFilterExpression = table.getLogicDeleteQueryFilterExpression();
        if (logicDeleteQueryFilterExpression != null) {
            logicDeleteQueryFilterExpression.apply(sqlPredicate);
        }
    }
}

